/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.util;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.istack.logging.Logger;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.message.RelatesToHeader;
import com.sun.xml.ws.rx.util.FiberExecutor;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

public final class Communicator {
    private static final Logger LOGGER = Logger.getLogger(Communicator.class);
    public final QName soapMustUnderstandAttributeName;
    private final SecureConversationInitiator scInitiator;
    private final AddressingVersion addressingVersion;
    private final SOAPVersion soapVersion;
    private final JAXBRIContext jaxbContext;
    private FiberExecutor fiberExecutor;
    private volatile EndpointAddress destinationAddress = null;

    public static Builder builder(String name) {
        return new Builder(name);
    }

    private Communicator(@NotNull String name, @NotNull Tube tubeline, @Nullable SecureConversationInitiator scInitiator, @NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion soapVersion, @NotNull JAXBRIContext jaxbContext) {
        this.fiberExecutor = new FiberExecutor(name, tubeline);
        this.scInitiator = scInitiator;
        this.addressingVersion = addressingVersion;
        this.soapVersion = soapVersion;
        this.soapMustUnderstandAttributeName = new QName(soapVersion.nsUri, "mustUnderstand");
        this.jaxbContext = jaxbContext;
    }

    public final Packet createRequestPacket(Object jaxbElement, String wsaAction, boolean expectReply) {
        Message message = Messages.create(this.jaxbContext, jaxbElement, this.soapVersion);
        return this.createRequestPacket(message, wsaAction, expectReply);
    }

    public final Packet createRequestPacket(Message message, String wsaAction, boolean expectReply) {
        if (this.destinationAddress == null) {
            throw new IllegalStateException("Destination address is not defined in this communicator instance");
        }
        Packet packet = new Packet(message);
        packet.endpointAddress = this.destinationAddress;
        packet.expectReply = expectReply;
        message.getHeaders().fillRequestAddressingHeaders(packet, this.addressingVersion, this.soapVersion, !expectReply, wsaAction);
        return packet;
    }

    public final Packet createRequestPacket(Packet originalRequestPacket, Object jaxbElement, String wsaAction, boolean expectReply) {
        if (originalRequestPacket != null) {
            Packet request = this.createResponsePacket(originalRequestPacket, jaxbElement, wsaAction, false);
            HeaderList requestHeaders = request.getMessage().getHeaders();
            if (expectReply) {
                String endpointAddress = originalRequestPacket.getMessage().getHeaders().getTo(this.addressingVersion, this.soapVersion);
                requestHeaders.add(this.createReplyToHeader(endpointAddress));
            }
            requestHeaders.remove(this.addressingVersion.relatesToTag);
            return request;
        }
        Message message = Messages.create(this.jaxbContext, jaxbElement, this.soapVersion);
        return this.createRequestPacket(message, wsaAction, expectReply);
    }

    private Header createReplyToHeader(String address) {
        WSEndpointReference wsepr = new WSEndpointReference(address, this.addressingVersion);
        return wsepr.createHeader(this.addressingVersion.replyToTag);
    }

    public Packet createEmptyRequestPacket(boolean expectReply) {
        if (this.destinationAddress == null) {
            throw new IllegalStateException("Destination address is not defined in this communicator instance");
        }
        Packet packet = new Packet();
        packet.endpointAddress = this.destinationAddress;
        packet.expectReply = expectReply;
        return packet;
    }

    public Packet createEmptyRequestPacket(String requestWsaAction, boolean expectReply) {
        return this.createRequestPacket(Messages.createEmpty(this.soapVersion), requestWsaAction, expectReply);
    }

    public Packet createResponsePacket(@NotNull Packet requestPacket, Object jaxbElement, String responseWsaAction, boolean isClientResponse) {
        assert (requestPacket != null) : "Request packet must not be 'null' when creating a response";
        if (!isClientResponse) {
            return requestPacket.createServerResponse(Messages.create(this.jaxbContext, jaxbElement, this.soapVersion), this.addressingVersion, this.soapVersion, responseWsaAction);
        }
        Packet response = this.createRequestPacket(jaxbElement, responseWsaAction, false);
        response.getMessage().getHeaders().add(new RelatesToHeader(this.addressingVersion.relatesToTag, requestPacket.getMessage().getHeaders().getMessageID(this.addressingVersion, this.soapVersion)));
        return response;
    }

    public Packet createResponsePacket(Packet requestPacket, Message message, String responseWsaAction) {
        if (requestPacket != null) {
            return requestPacket.createServerResponse(message, this.addressingVersion, this.soapVersion, responseWsaAction);
        }
        return this.createRequestPacket(message, responseWsaAction, false);
    }

    public Packet createEmptyResponsePacket(Packet requestPacket, String responseWsaAction) {
        if (requestPacket != null) {
            return requestPacket.createServerResponse(Messages.createEmpty(this.soapVersion), this.addressingVersion, this.soapVersion, responseWsaAction);
        }
        return this.createEmptyRequestPacket(responseWsaAction, false);
    }

    public Packet createNullResponsePacket(Packet requestPacket) {
        if (requestPacket.transportBackChannel != null) {
            requestPacket.transportBackChannel.close();
        }
        Packet emptyReturnPacket = new Packet();
        emptyReturnPacket.invocationProperties.putAll(requestPacket.invocationProperties);
        return emptyReturnPacket;
    }

    public final Packet setEmptyRequestMessage(Packet request, String wsaAction) {
        Message message = Messages.createEmpty(this.soapVersion);
        request.setMessage(message);
        message.getHeaders().fillRequestAddressingHeaders(request, this.addressingVersion, this.soapVersion, false, wsaAction);
        return request;
    }

    public final Packet setEmptyResponseMessage(Packet response, Packet request, String wsaAction) {
        Message message = Messages.createEmpty(this.soapVersion);
        response.setResponseMessage(request, message, this.addressingVersion, this.soapVersion, wsaAction);
        return response;
    }

    public String getWsaAction(Packet packet) {
        if (packet == null || packet.getMessage() == null) {
            return null;
        }
        return packet.getMessage().getHeaders().getAction(this.addressingVersion, this.soapVersion);
    }

    public String getWsaTo(Packet packet) {
        if (packet == null || packet.getMessage() == null) {
            return null;
        }
        return packet.getMessage().getHeaders().getTo(this.addressingVersion, this.soapVersion);
    }

    public SecurityTokenReferenceType tryStartSecureConversation(Packet request) throws WSTrustException {
        if (this.scInitiator == null) {
            return null;
        }
        Packet emptyPacket = this.createEmptyRequestPacket(false);
        emptyPacket.invocationProperties.putAll(request.invocationProperties);
        JAXBElement strElement = this.scInitiator.startSecureConversation(emptyPacket);
        return strElement != null ? (SecurityTokenReferenceType)strElement.getValue() : null;
    }

    public Packet send(@NotNull Packet request) {
        if (this.fiberExecutor == null) {
            LOGGER.fine("Cannot send messages: this Communicator instance has been closed");
        }
        return this.fiberExecutor.runSync(request);
    }

    public void sendAsync(@NotNull Packet request, @Nullable Fiber.CompletionCallback completionCallbackHandler) {
        if (this.fiberExecutor == null) {
            LOGGER.fine("Cannot send messages: this Communicator instance has been closed");
        }
        if (completionCallbackHandler != null) {
            this.fiberExecutor.start(request, completionCallbackHandler);
        } else {
            this.fiberExecutor.start(request, new Fiber.CompletionCallback(){

                @Override
                public void onCompletion(Packet response) {
                }

                @Override
                public void onCompletion(Throwable error) {
                    LOGGER.warning("Unexpected exception occured", error);
                }
            });
        }
    }

    @Nullable
    public EndpointAddress getDestinationAddress() {
        return this.destinationAddress;
    }

    public void setDestinationAddress(EndpointAddress newValue) {
        this.destinationAddress = newValue;
    }

    public void setDestinationAddressFrom(Packet packet) {
        this.destinationAddress = packet.endpointAddress;
    }

    public AddressingVersion getAddressingVersion() {
        return this.addressingVersion;
    }

    public SOAPVersion getSoapVersion() {
        return this.soapVersion;
    }

    public void close() {
        FiberExecutor fe = this.fiberExecutor;
        if (fe != null) {
            fe.close();
            this.fiberExecutor = null;
        }
    }

    public boolean isClosed() {
        return this.fiberExecutor == null;
    }

    public static final class Builder {
        private final String name;
        private Tube tubelineHead;
        private SecureConversationInitiator scInitiator;
        private AddressingVersion addressingVersion = AddressingVersion.W3C;
        private SOAPVersion soapVersion = SOAPVersion.SOAP_12;
        private JAXBRIContext jaxbContext;

        private Builder(String name) {
            this.name = name;
        }

        public Builder addressingVersion(AddressingVersion value) {
            this.addressingVersion = value;
            return this;
        }

        public Builder jaxbContext(JAXBRIContext value) {
            this.jaxbContext = value;
            return this;
        }

        public Builder secureConversationInitiator(SecureConversationInitiator value) {
            this.scInitiator = value;
            return this;
        }

        public Builder soapVersion(SOAPVersion value) {
            this.soapVersion = value;
            return this;
        }

        public Builder tubelineHead(Tube value) {
            this.tubelineHead = value;
            return this;
        }

        public Communicator build() {
            if (this.tubelineHead == null) {
                throw new IllegalStateException("Cannot create communicator instance: tubeline head has not been set.");
            }
            if (this.jaxbContext == null) {
                throw new IllegalStateException("Cannot create communicator instance: JAXB context has not been set.");
            }
            return new Communicator(this.name, this.tubelineHead, this.scInitiator, this.addressingVersion, this.soapVersion, this.jaxbContext);
        }
    }
}

