/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SecurityHeaderBlock;
import com.sun.xml.wss.impl.misc.SOAPElementExtension;
import com.sun.xml.wss.impl.misc.SecurityHeaderBlockImpl;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class SecurityHeader
extends SOAPElementExtension
implements SOAPElement {
    private final SOAPElement delegateHeader;
    private Document ownerDoc;
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    private SOAPElement currentSoapElement;
    private SOAPElement topMostSoapElement;

    public SecurityHeader(SOAPElement delegateHeader) {
        this.delegateHeader = delegateHeader;
        this.ownerDoc = delegateHeader.getOwnerDocument();
        this.topMostSoapElement = this.getFirstChildElement();
        this.currentSoapElement = null;
    }

    public void insertHeaderBlock(SecurityHeaderBlock block) throws XWSSecurityException {
        SOAPElement elementToInsert = block.getAsSoapElement();
        try {
            if (elementToInsert.getOwnerDocument() != this.ownerDoc) {
                elementToInsert = (SOAPElement)this.ownerDoc.importNode(elementToInsert, true);
            }
            this.updateTopMostSoapElement();
            this.insertBefore(elementToInsert, (org.w3c.dom.Node)this.topMostSoapElement);
        }
        catch (DOMException e) {
            log.log(Level.SEVERE, "WSS0376.error.inserting.header", e.getMessage());
            throw new XWSSecurityException(e);
        }
        this.topMostSoapElement = elementToInsert;
    }

    public void insertBefore(SecurityHeaderBlock block, org.w3c.dom.Node elem) throws XWSSecurityException {
        SOAPElement elementToInsert = block.getAsSoapElement();
        try {
            if (elementToInsert.getOwnerDocument() != this.ownerDoc) {
                elementToInsert = (SOAPElement)this.ownerDoc.importNode(elementToInsert, true);
            }
        }
        catch (DOMException e) {
            log.log(Level.SEVERE, "WSS0376.error.inserting.header", e.getMessage());
            throw new XWSSecurityException(e);
        }
        this.insertBefore(elementToInsert, elem);
    }

    public void appendChild(SecurityHeaderBlock block) throws XWSSecurityException {
        SOAPElement elementToInsert = block.getAsSoapElement();
        try {
            if (elementToInsert.getOwnerDocument() != this.ownerDoc) {
                elementToInsert = (SOAPElement)this.ownerDoc.importNode(elementToInsert, true);
            }
            this.appendChild(elementToInsert);
        }
        catch (DOMException e) {
            log.log(Level.SEVERE, "WSS0376.error.inserting.header", e.getMessage());
            throw new XWSSecurityException(e);
        }
    }

    public void insertHeaderBlockElement(SOAPElement blockElement) throws XWSSecurityException {
        try {
            if (blockElement.getOwnerDocument() != this.ownerDoc) {
                blockElement = (SOAPElement)this.ownerDoc.importNode(blockElement, true);
            }
            this.updateTopMostSoapElement();
            this.insertBefore(blockElement, (org.w3c.dom.Node)this.topMostSoapElement);
        }
        catch (DOMException e) {
            log.log(Level.SEVERE, "WSS0376.error.inserting.header", e.getMessage());
            throw new XWSSecurityException(e);
        }
        this.topMostSoapElement = blockElement;
    }

    public SecurityHeaderBlock getCurrentHeaderBlock(Class implType) throws XWSSecurityException {
        if (null == this.currentSoapElement) {
            this.currentSoapElement = this.getFirstChildElement();
        } else {
            org.w3c.dom.Node nextChild;
            for (nextChild = this.currentSoapElement.getNextSibling(); null != nextChild && nextChild.getNodeType() != 1; nextChild = nextChild.getNextSibling()) {
            }
            this.currentSoapElement = (SOAPElement)nextChild;
        }
        return SecurityHeaderBlockImpl.fromSoapElement(this.currentSoapElement, implType);
    }

    public SOAPElement getCurrentHeaderBlockElement() {
        if (null == this.currentSoapElement) {
            this.currentSoapElement = this.getFirstChildElement();
        } else {
            org.w3c.dom.Node nextChild;
            for (nextChild = this.currentSoapElement.getNextSibling(); null != nextChild && nextChild.getNodeType() != 1; nextChild = nextChild.getNextSibling()) {
            }
            this.currentSoapElement = (SOAPElement)nextChild;
        }
        return this.currentSoapElement;
    }

    public void setCurrentHeaderElement(SOAPElement currentElement) throws XWSSecurityException {
        if (currentElement != null && currentElement.getParentNode() != this.delegateHeader) {
            log.log(Level.SEVERE, "WSS0396.notchild.securityHeader", new Object[]{currentElement.toString()});
            throw new XWSSecurityException("Element set is not a child of SecurityHeader");
        }
        this.currentSoapElement = currentElement;
    }

    public SOAPElement getCurrentHeaderElement() {
        return this.currentSoapElement;
    }

    public void updateTopMostSoapElement() {
        this.topMostSoapElement = this.getNextSiblingOfTimestamp();
    }

    public SOAPElement getFirstChildElement() {
        Iterator eachChild = this.getChildElements();
        Node node = null;
        if (eachChild.hasNext()) {
            node = (Node)eachChild.next();
        } else {
            return null;
        }
        while (node.getNodeType() != 1 && eachChild.hasNext()) {
            node = (Node)eachChild.next();
        }
        if (null != node) {
            return (SOAPElement)node;
        }
        return null;
    }

    public SOAPElement getNextSiblingOfTimestamp() {
        SOAPElement firstElement = this.getFirstChildElement();
        if (firstElement != null && "Timestamp".equals(firstElement.getLocalName())) {
            org.w3c.dom.Node temp = firstElement.getNextSibling();
            if (temp == null) {
                return null;
            }
            while (temp.getNodeType() != 1 && temp.getNextSibling() != null) {
                temp = (Node)temp.getNextSibling();
            }
            if (null != temp) {
                while (temp != null && "SignatureConfirmation".equals(temp.getLocalName())) {
                    if ((temp = temp.getNextSibling()) == null) {
                        return null;
                    }
                    while (temp.getNodeType() != 1 && temp.getNextSibling() != null) {
                        temp = (Node)temp.getNextSibling();
                    }
                }
                if (temp == null) {
                    return null;
                }
                return (SOAPElement)temp;
            }
            return null;
        }
        return firstElement;
    }

    public SOAPElement getAsSoapElement() {
        return this.delegateHeader;
    }

    public void setRole(String roleURI) {
        throw new UnsupportedOperationException();
    }

    public String getRole() {
        throw new UnsupportedOperationException();
    }

    public void setMustUnderstand(boolean mustUnderstand) {
        throw new UnsupportedOperationException();
    }

    public boolean isMustUnderstand() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SOAPElement addAttribute(Name arg0, String arg1) throws SOAPException {
        return this.delegateHeader.addAttribute(arg0, arg1);
    }

    @Override
    public SOAPElement addChildElement(String arg0) throws SOAPException {
        return this.delegateHeader.addChildElement(arg0);
    }

    @Override
    public SOAPElement addChildElement(String arg0, String arg1) throws SOAPException {
        return this.delegateHeader.addChildElement(arg0, arg1);
    }

    @Override
    public SOAPElement addChildElement(String arg0, String arg1, String arg2) throws SOAPException {
        return this.delegateHeader.addChildElement(arg0, arg1, arg2);
    }

    @Override
    public SOAPElement addChildElement(Name arg0) throws SOAPException {
        return this.delegateHeader.addChildElement(arg0);
    }

    @Override
    public SOAPElement addChildElement(SOAPElement arg0) throws SOAPException {
        return this.delegateHeader.addChildElement(arg0);
    }

    @Override
    public SOAPElement addNamespaceDeclaration(String arg0, String arg1) throws SOAPException {
        return this.delegateHeader.addNamespaceDeclaration(arg0, arg1);
    }

    @Override
    public SOAPElement addTextNode(String arg0) throws SOAPException {
        return this.delegateHeader.addTextNode(arg0);
    }

    @Override
    public org.w3c.dom.Node appendChild(org.w3c.dom.Node arg0) throws DOMException {
        return this.delegateHeader.appendChild(arg0);
    }

    public SOAPElement makeUsable(SOAPElement elem) throws XWSSecurityException {
        SOAPElement elementToInsert = elem;
        try {
            if (elem.getOwnerDocument() != this.ownerDoc) {
                elementToInsert = (SOAPElement)this.ownerDoc.importNode(elem, true);
            }
            return elementToInsert;
        }
        catch (DOMException e) {
            log.log(Level.SEVERE, "WSS0376.error.inserting.header", e.getMessage());
            throw new XWSSecurityException(e);
        }
    }

    @Override
    public org.w3c.dom.Node cloneNode(boolean arg0) {
        return this.delegateHeader.cloneNode(arg0);
    }

    @Override
    public void detachNode() {
        this.delegateHeader.detachNode();
    }

    public boolean equals(Object obj) {
        return this.delegateHeader.equals(obj);
    }

    @Override
    public Iterator getAllAttributes() {
        return this.delegateHeader.getAllAttributes();
    }

    @Override
    public String getAttribute(String arg0) {
        return this.delegateHeader.getAttribute(arg0);
    }

    @Override
    public Attr getAttributeNode(String arg0) {
        return this.delegateHeader.getAttributeNode(arg0);
    }

    @Override
    public Attr getAttributeNodeNS(String arg0, String arg1) {
        return this.delegateHeader.getAttributeNodeNS(arg0, arg1);
    }

    @Override
    public String getAttributeNS(String arg0, String arg1) {
        return this.delegateHeader.getAttributeNS(arg0, arg1);
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.delegateHeader.getAttributes();
    }

    @Override
    public String getAttributeValue(Name arg0) {
        return this.delegateHeader.getAttributeValue(arg0);
    }

    @Override
    public Iterator getChildElements() {
        return this.delegateHeader.getChildElements();
    }

    @Override
    public Iterator getChildElements(Name arg0) {
        return this.delegateHeader.getChildElements(arg0);
    }

    @Override
    public NodeList getChildNodes() {
        return this.delegateHeader.getChildNodes();
    }

    @Override
    public Name getElementName() {
        return this.delegateHeader.getElementName();
    }

    @Override
    public NodeList getElementsByTagName(String arg0) {
        return this.delegateHeader.getElementsByTagName(arg0);
    }

    @Override
    public NodeList getElementsByTagNameNS(String arg0, String arg1) {
        return this.delegateHeader.getElementsByTagNameNS(arg0, arg1);
    }

    @Override
    public String getEncodingStyle() {
        return this.delegateHeader.getEncodingStyle();
    }

    @Override
    public org.w3c.dom.Node getFirstChild() {
        return this.delegateHeader.getFirstChild();
    }

    @Override
    public org.w3c.dom.Node getLastChild() {
        return this.delegateHeader.getLastChild();
    }

    @Override
    public String getLocalName() {
        return this.delegateHeader.getLocalName();
    }

    @Override
    public Iterator getNamespacePrefixes() {
        return this.delegateHeader.getNamespacePrefixes();
    }

    @Override
    public String getNamespaceURI() {
        return this.delegateHeader.getNamespaceURI();
    }

    @Override
    public String getNamespaceURI(String arg0) {
        return this.delegateHeader.getNamespaceURI(arg0);
    }

    @Override
    public org.w3c.dom.Node getNextSibling() {
        return this.delegateHeader.getNextSibling();
    }

    @Override
    public String getNodeName() {
        return this.delegateHeader.getNodeName();
    }

    @Override
    public short getNodeType() {
        return this.delegateHeader.getNodeType();
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.delegateHeader.getNodeValue();
    }

    @Override
    public Document getOwnerDocument() {
        return this.delegateHeader.getOwnerDocument();
    }

    @Override
    public SOAPElement getParentElement() {
        return this.delegateHeader.getParentElement();
    }

    @Override
    public org.w3c.dom.Node getParentNode() {
        return this.delegateHeader.getParentNode();
    }

    @Override
    public String getPrefix() {
        return this.delegateHeader.getPrefix();
    }

    @Override
    public org.w3c.dom.Node getPreviousSibling() {
        return this.delegateHeader.getPreviousSibling();
    }

    @Override
    public String getTagName() {
        return this.delegateHeader.getTagName();
    }

    @Override
    public String getValue() {
        return this.delegateHeader.getValue();
    }

    @Override
    public Iterator getVisibleNamespacePrefixes() {
        return this.delegateHeader.getVisibleNamespacePrefixes();
    }

    @Override
    public boolean hasAttribute(String arg0) {
        return this.delegateHeader.hasAttribute(arg0);
    }

    @Override
    public boolean hasAttributeNS(String arg0, String arg1) {
        return this.delegateHeader.hasAttributeNS(arg0, arg1);
    }

    @Override
    public boolean hasAttributes() {
        return this.delegateHeader.hasAttributes();
    }

    @Override
    public boolean hasChildNodes() {
        return this.delegateHeader.hasChildNodes();
    }

    public int hashCode() {
        return this.delegateHeader.hashCode();
    }

    @Override
    public org.w3c.dom.Node insertBefore(org.w3c.dom.Node arg0, org.w3c.dom.Node arg1) throws DOMException {
        return this.delegateHeader.insertBefore(arg0, arg1);
    }

    @Override
    public boolean isSupported(String arg0, String arg1) {
        return this.delegateHeader.isSupported(arg0, arg1);
    }

    @Override
    public void normalize() {
        this.delegateHeader.normalize();
    }

    @Override
    public void recycleNode() {
        this.delegateHeader.recycleNode();
    }

    @Override
    public void removeAttribute(String arg0) throws DOMException {
        this.delegateHeader.removeAttribute(arg0);
    }

    @Override
    public boolean removeAttribute(Name arg0) {
        return this.delegateHeader.removeAttribute(arg0);
    }

    @Override
    public Attr removeAttributeNode(Attr arg0) throws DOMException {
        return this.delegateHeader.removeAttributeNode(arg0);
    }

    @Override
    public void removeAttributeNS(String arg0, String arg1) throws DOMException {
        this.delegateHeader.removeAttributeNS(arg0, arg1);
    }

    @Override
    public org.w3c.dom.Node removeChild(org.w3c.dom.Node arg0) throws DOMException {
        return this.delegateHeader.removeChild(arg0);
    }

    @Override
    public void removeContents() {
        this.delegateHeader.removeContents();
    }

    @Override
    public boolean removeNamespaceDeclaration(String arg0) {
        return this.delegateHeader.removeNamespaceDeclaration(arg0);
    }

    @Override
    public org.w3c.dom.Node replaceChild(org.w3c.dom.Node arg0, org.w3c.dom.Node arg1) throws DOMException {
        return this.delegateHeader.replaceChild(arg0, arg1);
    }

    @Override
    public void setAttribute(String arg0, String arg1) throws DOMException {
        this.delegateHeader.setAttribute(arg0, arg1);
    }

    @Override
    public Attr setAttributeNode(Attr arg0) throws DOMException {
        return this.delegateHeader.setAttributeNode(arg0);
    }

    @Override
    public Attr setAttributeNodeNS(Attr arg0) throws DOMException {
        return this.delegateHeader.setAttributeNodeNS(arg0);
    }

    @Override
    public void setAttributeNS(String arg0, String arg1, String arg2) throws DOMException {
        this.delegateHeader.setAttributeNS(arg0, arg1, arg2);
    }

    @Override
    public void setEncodingStyle(String arg0) throws SOAPException {
        this.delegateHeader.setEncodingStyle(arg0);
    }

    @Override
    public void setNodeValue(String arg0) throws DOMException {
        this.delegateHeader.setNodeValue(arg0);
    }

    @Override
    public void setParentElement(SOAPElement arg0) throws SOAPException {
        this.delegateHeader.setParentElement(arg0);
    }

    @Override
    public void setPrefix(String arg0) throws DOMException {
        this.delegateHeader.setPrefix(arg0);
    }

    @Override
    public void setValue(String arg0) {
        this.delegateHeader.setValue(arg0);
    }

    public String toString() {
        return this.delegateHeader.toString();
    }

    @Override
    public String getBaseURI() {
        return this.delegateHeader.getBaseURI();
    }

    @Override
    public short compareDocumentPosition(org.w3c.dom.Node other) throws DOMException {
        return this.delegateHeader.compareDocumentPosition(other);
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.delegateHeader.getTextContent();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.delegateHeader.setTextContent(textContent);
    }

    @Override
    public boolean isSameNode(org.w3c.dom.Node other) {
        return this.delegateHeader.isSameNode(other);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return this.delegateHeader.lookupPrefix(namespaceURI);
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return this.delegateHeader.isDefaultNamespace(namespaceURI);
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return this.delegateHeader.lookupNamespaceURI(prefix);
    }

    @Override
    public boolean isEqualNode(org.w3c.dom.Node arg) {
        return this.delegateHeader.isEqualNode(arg);
    }

    @Override
    public Object getFeature(String feature, String version) {
        return this.delegateHeader.getFeature(feature, version);
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.delegateHeader.setUserData(key, data, handler);
    }

    @Override
    public Object getUserData(String key) {
        return this.delegateHeader.getUserData(key);
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        this.delegateHeader.setIdAttribute(name, isId);
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        this.delegateHeader.setIdAttributeNode(idAttr, isId);
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        this.delegateHeader.setIdAttributeNS(namespaceURI, localName, isId);
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return this.delegateHeader.getSchemaTypeInfo();
    }

    @Override
    public Iterator getAllAttributesAsQNames() {
        return this.delegateHeader.getAllAttributesAsQNames();
    }
}

