/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.standalone;

import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Adapter;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;

public class StaticResourcesAdapter
implements Adapter {
    static Properties contentTypes = new Properties();
    private String rootFolder = ".";
    private File rootFolderF;
    private ConcurrentHashMap<String, File> cache = new ConcurrentHashMap();

    static void initContentTypes() {
        contentTypes.put("html", "text/html");
        contentTypes.put("txt", "text/plain");
    }

    public StaticResourcesAdapter() {
        this.rootFolder = SelectorThread.getWebAppRootPath();
        this.rootFolderF = new File(this.rootFolder);
        try {
            this.rootFolder = this.rootFolderF.getCanonicalPath();
            SelectorThread.logger().log(Level.INFO, "Servicing page from: " + this.rootFolder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void service(Request req, Response res) throws Exception {
        String ext;
        String ct;
        MessageBytes mb = req.requestURI();
        String uri = req.requestURI().toString();
        if (uri.indexOf("..") >= 0) {
            res.setStatus(404);
            return;
        }
        File resource = this.cache.get(uri);
        if (resource == null) {
            resource = new File(this.rootFolderF, uri);
            this.cache.put(uri, resource);
        }
        if (!resource.getCanonicalPath().startsWith(this.rootFolder)) {
            res.setStatus(404);
            return;
        }
        if (resource.isDirectory()) {
            resource = new File(resource, "index.html");
            this.cache.put(uri, resource);
        }
        if (!resource.exists()) {
            SelectorThread.logger().log(Level.INFO, "File not found  " + resource);
            res.setStatus(404);
            return;
        }
        res.setStatus(200);
        int dot = uri.lastIndexOf(".");
        if (dot > 0 && (ct = this.getContentType(ext = uri.substring(dot + 1))) != null) {
            res.setContentType(ct);
        }
        res.setContentLength((int)resource.length());
        res.sendHeaders();
        FileInputStream fis = new FileInputStream(resource);
        byte[] b = new byte[8192];
        ByteChunk chunk = new ByteChunk();
        int rd = 0;
        while ((rd = fis.read(b)) > 0) {
            chunk.setBytes(b, 0, rd);
            res.doWrite(chunk);
        }
        try {
            req.action(ActionCode.ACTION_POST_REQUEST, null);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        res.finish();
    }

    public String getContentType(String ext) {
        return contentTypes.getProperty(ext, "text/plain");
    }

    public void afterService(Request req, Response res) throws Exception {
        req.recycle();
        res.recycle();
    }

    public void fireAdapterEvent(String string, Object object) {
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    static {
        StaticResourcesAdapter.initContentTypes();
    }
}

