/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws;

import com.sun.istack.tools.MaskingClassLoader;
import com.sun.istack.tools.ParallelWorldClassLoader;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.wscompile.Options;
import com.sun.tools.xjc.api.util.ToolsJarNotFoundException;
import com.sun.xml.bind.util.Which;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;

public final class Invoker {
    static final String[] maskedPackages = new String[]{"com.sun.istack.tools.", "com.sun.tools.jxc.", "com.sun.tools.xjc.", "com.sun.tools.ws.", "com.sun.codemodel.", "com.sun.relaxng.", "com.sun.xml.xsom.", "com.sun.xml.bind.", "com.ctc.wstx.", "org.codehaus.stax2.", "com.sun.xml.messaging.saaj.", "com.sun.xml.ws.", "com.oracle.webservices.api."};
    public static final boolean noSystemProxies;

    static int invoke(String mainClass, String[] args) throws Throwable {
        if (!noSystemProxies) {
            try {
                System.setProperty("java.net.useSystemProxies", "true");
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        ClassLoader oldcc = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = Invoker.class.getClassLoader();
            if (Arrays.asList(args).contains("-Xendorsed")) {
                cl = Invoker.createClassLoader(cl);
            } else {
                int targetArgIndex = Arrays.asList(args).indexOf("-target");
                Options.Target targetVersion = targetArgIndex != -1 ? Options.Target.parse(args[targetArgIndex + 1]) : Options.Target.getDefault();
                Options.Target loadedVersion = Options.Target.getLoadedAPIVersion();
                if (!loadedVersion.isLaterThan(targetVersion)) {
                    if (Service.class.getClassLoader() == null) {
                        System.err.println(WscompileMessages.INVOKER_NEED_ENDORSED(loadedVersion.getVersion(), targetVersion.getVersion()));
                    } else {
                        System.err.println(WscompileMessages.WRAPPER_TASK_LOADING_INCORRECT_API(loadedVersion.getVersion(), Which.which(Service.class), targetVersion.getVersion()));
                    }
                    int n = -1;
                    return n;
                }
                ArrayList<URL> urls = new ArrayList<URL>();
                Invoker.findToolsJar(cl, urls);
                if (urls.size() > 0) {
                    ArrayList<String> mask = new ArrayList<String>(Arrays.asList(maskedPackages));
                    cl = new MaskingClassLoader(cl, mask);
                    cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), cl);
                    cl = new ParallelWorldClassLoader(cl, "");
                }
            }
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> compileTool = cl.loadClass(mainClass);
            Constructor<?> ctor = compileTool.getConstructor(OutputStream.class);
            Object tool = ctor.newInstance(System.out);
            Method runMethod = compileTool.getMethod("run", String[].class);
            boolean r = (Boolean)runMethod.invoke(tool, new Object[]{args});
            int n = r ? 0 : 1;
            return n;
        }
        catch (ToolsJarNotFoundException e) {
            System.err.println(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldcc);
        }
        return -1;
    }

    public static boolean checkIfLoading21API() {
        try {
            Service.class.getMethod("getPort", Class.class, WebServiceFeature[].class);
            return true;
        }
        catch (NoSuchMethodException e) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return false;
    }

    public static boolean checkIfLoading22API() {
        try {
            Service.class.getMethod("create", URL.class, QName.class, WebServiceFeature[].class);
            return true;
        }
        catch (NoSuchMethodException e) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return false;
    }

    public static ClassLoader createClassLoader(ClassLoader cl) throws ClassNotFoundException, IOException, ToolsJarNotFoundException {
        URL[] urls = Invoker.findIstack22APIs(cl);
        if (urls.length == 0) {
            return cl;
        }
        ArrayList<String> mask = new ArrayList<String>(Arrays.asList(maskedPackages));
        if (urls.length > 1) {
            mask.add("javax.xml.bind.");
            mask.add("javax.xml.ws.");
        }
        cl = new MaskingClassLoader(cl, mask);
        cl = new URLClassLoader(urls, cl);
        cl = new ParallelWorldClassLoader(cl, "");
        return cl;
    }

    private static URL[] findIstack22APIs(ClassLoader cl) throws ClassNotFoundException, IOException, ToolsJarNotFoundException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (Service.class.getClassLoader() == null) {
            URL res = cl.getResource("javax/xml/ws/EndpointContext.class");
            if (res == null) {
                throw new ClassNotFoundException("There's no JAX-WS 2.2 API in the classpath");
            }
            urls.add(ParallelWorldClassLoader.toJarUrl(res));
            res = cl.getResource("javax/xml/bind/JAXBPermission.class");
            if (res == null) {
                throw new ClassNotFoundException("There's no JAXB 2.2 API in the classpath");
            }
            urls.add(ParallelWorldClassLoader.toJarUrl(res));
        }
        Invoker.findToolsJar(cl, urls);
        return urls.toArray(new URL[urls.size()]);
    }

    private static void findToolsJar(ClassLoader cl, List<URL> urls) throws ToolsJarNotFoundException, MalformedURLException {
        try {
            Class.forName("com.sun.tools.javac.Main", false, cl);
        }
        catch (ClassNotFoundException e) {
            File jreHome = new File(System.getProperty("java.home"));
            File toolsJar = new File(jreHome.getParent(), "lib/tools.jar");
            if (!toolsJar.exists()) {
                throw new ToolsJarNotFoundException(toolsJar);
            }
            urls.add(toolsJar.toURL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        boolean noSysProxiesProperty = false;
        try {
            noSysProxiesProperty = Boolean.getBoolean(Invoker.class.getName() + ".noSystemProxies");
        }
        catch (SecurityException securityException) {
        }
        finally {
            noSystemProxies = noSysProxiesProperty;
        }
    }
}

