﻿using System.ServiceModel;

using HIPS.ServiceContracts.Cda;
using HIPS.ServiceContracts.Cda.Message;

namespace HIPS.Client.Proxy
{
    /// <summary>
    /// This pre-built client class can be referenced by a .net client application in lieu of generating client classes from the WSDL.
    /// </summary>
    public class CdaProxy : ClientBase<ICdaService>, ICdaService
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="CdaProxy" /> class.
        /// </summary>
        /// <param name="endpointName"></param>
        public CdaProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Creates a CDA discharge summary document that wraps a PDF document body.
        /// This may be for the purpose of uploading the discharge summary to the
        /// PCEHR or for provider-to-provider (P2P) secure message delivery (SMD).
        /// This takes in the PDF document, required metadata, and any attachments
        /// and creates a CDA document.
        /// </summary>
        /// <param name="request">Request containing a PDF and required metadata for creating the CDA package.</param>
        /// <returns>Response containing details of the created document.</returns>
        public CreateDischargeSummaryLevel1AResponse CreateDischargeSummaryLevel1A(CreateDischargeSummaryLevel1ARequest request)
        {
            return Channel.CreateDischargeSummaryLevel1A(request);
        }
    }
}