﻿using System.Collections.Generic;
using System.ServiceModel;
using HIPS.CommonSchemas.Hi;
using HIPS.Reference.ServiceContracts;

namespace HIPS.Client.Proxy
{
    public class HiReferenceProxy : ClientBase<IHiReferenceService>, IHiReferenceService
    {
        /// <summary>
        /// Default constructor
        /// </summary>
        /// <param name="endpointName"></param>
        public HiReferenceProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Gets the Country List.
        /// </summary>
        /// <returns></returns>
        public List<HiCountry> GetHiCountries()
        {
            return Channel.GetHiCountries();
        }

        /// <summary>
        /// Gets the LevelType List.
        /// </summary>
        /// <returns></returns>
        public List<HiLevelType> GetHiLevelTypes()
        {
            return Channel.GetHiLevelTypes();
        }

        /// <summary>
        /// Gets the PostalDeliveryType List.
        /// </summary>
        /// <returns></returns>
        public List<HiPostalDeliveryType> GetHiPostalDeliveryTypes()
        {
            return Channel.GetHiPostalDeliveryTypes();
        }

        /// <summary>
        /// Gets the Sex List.
        /// </summary>
        /// <returns></returns>
        public List<HiSex> GetHiSexes()
        {
            return Channel.GetHiSexes();
        }

        /// <summary>
        /// Gets the State List.
        /// </summary>
        /// <returns></returns>
        public List<HiState> GetHiStates()
        {
            return Channel.GetHiStates();
        }

        /// <summary>
        /// Gets the StreetSuffixTypes List.
        /// </summary>
        /// <returns></returns>
        public List<HiStreetSuffixType> GetHiStreetSuffixTypes()
        {
            return Channel.GetHiStreetSuffixTypes();
        }

        /// <summary>
        /// Gets the StreetType List.
        /// </summary>
        /// <returns></returns>
        public List<HiStreetType> GetHiStreetTypes()
        {
            return Channel.GetHiStreetTypes();
        }

        /// <summary>
        /// Gets the UnitType List.
        /// </summary>
        /// <returns></returns>
        public List<HiUnitType> GetHiUnitTypes()
        {
            return Channel.GetHiUnitTypes();
        }
    }
}