﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.CommonSchemas.Hi
{
    /// <summary>
    /// This class represents a HI PostalDeliveryType for addressing
    /// </summary>
    [KnownType(typeof(HiPostalDeliveryType))]
    [Serializable]
    [DataContract]
    public class HiPostalDeliveryType : BaseExposedCode
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="HiPostalDeliveryType"/> class.
        /// </summary>
        public HiPostalDeliveryType()
            : base()
        {
        }

        /// <summary>
        /// Gets or sets the PostalDeliveryType id.
        /// </summary>
        /// <value>
        /// The PostalDeliveryType id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ApplicationGeneratedKey)]
        public int? PostalDeliveryTypeId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }
    }
}