﻿using System;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;

namespace HIPS.ConsentSchemas
{
    /// <summary>
    /// Represents a consent status for an episode.
    /// </summary>
    [KnownType(typeof(EpisodeConsentResponse))]
    [Serializable]
    [DataContract]
    public class EpisodeConsentResponse
    {
        #region Private Members

        private EpisodeConsentStatus consentStatus;
        private HipsResponse response;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// The Consent Status of the Episode
        /// </summary>
        [DataMember]
        public EpisodeConsentStatus ConsentStatus
        {
            get { return consentStatus; }
            set { consentStatus = value; }
        }

        /// <summary>
        /// Gets or sets the HipsResponse.
        /// Common Response Object.
        /// </summary>
        /// <value>
        /// The hipsResponse
        /// </value>
        [DataMember]
        public HipsResponse Response
        {
            get { return response; }
            set { response = value; }
        }

        #endregion Properties
    }
}