﻿namespace HIPS.IhiSchemas.Schemas
{
    /// <summary>
    /// Represents the gender of a person.
    /// </summary>
    public enum Gender
    {
        /// <summary>
        /// Female gender.
        /// </summary>
        Female = 2,

        /// <summary>
        /// Male gender.
        /// </summary>
        Male = 1,

        /// <summary>
        /// Indeterminate gender.
        /// </summary>
        Indeterminate = 4,

        /// <summary>
        /// Gender not specified.
        /// </summary>
        NotSpecified = -1
    };

    /// <summary>
    /// This enumeration represents the success or failure reason of an IHI lookup.
    /// </summary>
    public enum IhiLookupReturnStatus
    {
        /// <summary>
        /// The request executed correctly.
        /// </summary>
        OK = 0,

        /// <summary>
        /// The patient was not found with the specified search data.
        /// </summary>
        InvalidPatient = 1,

        /// <summary>
        /// The user details were not valid.
        /// </summary>
        InvalidUser = 2,

        /// <summary>
        /// The HI Service returned an error.
        /// </summary>
        ServiceError = 9,

        /// <summary>
        /// The application failed. Details recorded within the application database.
        /// </summary>
        SystemError = 99
    }

    /// <summary>
    /// The type of name search that is being used to lookup an IHI
    /// </summary>
    public enum IhiNameSearchType
    {
        /// <summary>
        /// Registered name.
        /// </summary>
        Registered,

        /// <summary>
        /// Current name.
        /// </summary>
        Current
    };
}