﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the HospitalHealthProviderIndividual table
    /// </summary>
    public class HospitalHealthProviderIndividualDl : BaseDl
    {
        #region Constructors

        /// <summary>
        /// Creates a data access object for the link between a hospital and a health provider individual.
        /// </summary>
        /// <param name="user">The person responsible for the action.</param>
        public HospitalHealthProviderIndividualDl(UserDetails user)
        {
            this.User = user;
        }

        #endregion Constructors

        #region Methods

        /// <summary>
        /// Deletes the specified health care provider.
        /// </summary>
        /// <param name="HealthCareProvider">The health care provider.</param>
        /// <returns></returns>
        // Not implemented yet as it is not required right now.
        public bool Delete(HospitalHealthProviderIndividual hospitalHealthProviderIndividual)
        {
            throw new NotImplementedException("This method has not been implemented");
        }

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        // Not implemented yet as it is not required right now.
        public List<HospitalHealthProviderIndividual> GetAll(int healthProviderIndividualId)
        {
            throw new NotImplementedException("This method has not been implemented");
        }

        /// <summary>
        /// Inserts the specified hospital health care provider.
        /// </summary>
        /// <param name="HealthCareProvider">The health care provider.</param>
        /// <returns></returns>
        public bool Insert(HospitalHealthProviderIndividual hospitalHealthProviderIndividual, SqlTransaction transaction)
        {
            using (SqlCommand command = GetSqlCommand("hips.HospitalHealthProviderIndividualInsert", transaction))
            {
                return base.Insert<HospitalHealthProviderIndividual>(hospitalHealthProviderIndividual, command);
            }
        }

        /// <summary>
        /// Updates the specified health care provider.
        /// </summary>
        /// <param name="HealthCareProvider">The health care provider.</param>
        /// <returns></returns>
        // Not implemented yet as it is not required right now.
        public bool Update(HospitalHealthProviderIndividual hospitalHealthProviderIndividual)
        {
            throw new NotImplementedException("This method has not been implemented");
        }

        #endregion Methods
    }
}