﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a hospital and the health provider that works in it
    /// </summary>
    [KnownType(typeof(HospitalProvider))]
    [Serializable]
    [DataContract]
    public class HospitalProvider : BaseSchema
    {
        #region Private Members

        private int hospitalId;
        private int healthProviderIndividualId;
        private string cisProviderIdentifier;
        private string pasProviderIdentifier;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the hospital id.
        /// </summary>
        /// <value>
        /// The hospital id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ApplicationGeneratedKey)]
        public int HospitalId
        {
            get
            {
                return hospitalId;
            }
            set
            {
                hospitalId = value;
            }
        }

        /// <summary>
        /// Gets or sets the health provider individual id.
        /// </summary>
        /// <value>
        /// The health provider individual id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ApplicationGeneratedKey)]
        public int HealthProviderIndividualId
        {
            get
            {
                return healthProviderIndividualId;
            }
            set
            {
                healthProviderIndividualId = value;
            }
        }

        /// <summary>
        /// Gets or sets the Clinical Information System (CIS) provider identifier used at the hospital facility (e.g. Oacis User ID)
        /// </summary>
        /// <value>
        /// The cis provider identifier.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(HIPS.Base.Schemas.Enumerators.DatabaseColumnType.Data)]
        public string CisProviderIdentifier
        {
            get
            {
                return this.cisProviderIdentifier;
            }
            set
            {
                this.cisProviderIdentifier = value;

#if PUMA_CLIENT
                RaisePropertyChanged(() => CisProviderIdentifier);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the Identifier of this provider allocated by the Patient Administration System (PAS) at the hospital facility (e.g. Homer Doctor Code)
        /// </summary>
        /// <value>
        /// The pas provider identifier.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(HIPS.Base.Schemas.Enumerators.DatabaseColumnType.Data)]
        public string PasProviderIdentifier
        {
            get
            {
                return this.pasProviderIdentifier;
            }
            set
            {
                this.pasProviderIdentifier = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => PasProviderIdentifier);
#endif
            }
        }

        #endregion Properties
    }
}