﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents an audit record for an HPII lookup
    /// </summary>
    [KnownType(typeof(HpiiLookupAudit))]
    [Serializable]
    [DataContract]
    public class HpiiLookupAudit : BaseSchema
    {
        #region private members

        private string request;
        private string response;

        #endregion private members

        #region Constructor

        /// <summary>
        /// Initialises a new instance of the <see cref="HpiiLookupAudit" /> class.
        /// </summary>
        public HpiiLookupAudit()
        {
            HpiiStatusId = -1; // Undefined (can't reference HpiiSchemas.HpiiStatus from here)
        }

        #endregion Constructor

        /// <summary>
        /// Gets or sets the Australian State Id
        /// </summary>
        /// <value>
        /// The Australian State Id
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string AustralianState { get; set; }

        /// <summary>
        /// Gets or sets the Batch Id
        /// </summary>
        /// <value>
        /// The Batch Id
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string BatchIdentifier { get; set; }

        /// <summary>
        /// Gets or sets the Batch Item Id
        /// </summary>
        /// <value>
        /// The Batch Item Id
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int? BatchItemId { get; set; }

        /// <summary>
        /// Gets or sets the Country Code
        /// </summary>
        /// <value>
        /// The Country Code
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string CountryCode { get; set; }

        /// <summary>
        /// Gets or sets the Date Of Birth
        /// </summary>
        /// <value>
        /// The Date Of Birth
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public DateTime? DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the Family Name
        /// </summary>
        /// <value>
        /// The Family Name
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets the Given Names
        /// </summary>
        /// <value>
        /// The Given Names
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string GivenNames { get; set; }

        /// <summary>
        /// Gets or sets the Hi Web Service Name
        /// </summary>
        /// <value>
        /// The Hi Web Service Name
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string HiWebServiceName { get; set; }

        /// <summary>
        /// Gets or sets the Hi Web Service Version
        /// </summary>
        /// <value>
        /// The Hi Web Service Version
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string HiWebServiceVersion { get; set; }

        /// <summary>
        /// Gets or sets the HPII lookup audit ID.
        /// </summary>
        /// <value>
        /// The hpii lookup audit ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? HpiiLookupAuditId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the Hpii Number
        /// </summary>
        /// <value>
        /// The Hpii Number
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string HpiiNumber { get; set; }

        /// <summary>
        /// Gets or sets the Hpii StatusId
        /// </summary>
        /// <value>
        /// The Hpii StatusId
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int? HpiiStatusId { get; set; }

        /// <summary>
        /// Gets or sets the HpiO
        /// </summary>
        /// <value>
        /// The HpiO
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string HpiO { get; set; }

        /// <summary>
        /// Gets or sets the Identifier Type of the local identifier related to the search
        /// </summary>
        /// <value>
        /// The Identifier Type
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string IdentifierType { get; set; }

        /// <summary>
        /// Gets or sets the Identifier Value of the local identifier related to the search
        /// </summary>
        /// <value>
        /// The Identifier Value
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string IdentifierValue { get; set; }

        /// <summary>
        /// Gets or sets the Message
        /// </summary>
        /// <value>
        /// The Message
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Message { get; set; }

        /// <summary>
        /// Gets or sets the Operator
        /// </summary>
        /// <value>
        /// The Operator
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Operator { get; set; }

        /// <summary>
        /// Gets or sets the Operator HpiI
        /// </summary>
        /// <value>
        /// The Operator HpiI
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string OperatorHpiI { get; set; }

        /// <summary>
        /// Gets or sets the Postcode
        /// </summary>
        /// <value>
        /// The Postcode
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Postcode { get; set; }

        /// <summary>
        /// Gets or sets the Registration Id
        /// </summary>
        /// <value>
        /// The Registration Id
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string RegistrationId { get; set; }

        /// <summary>
        /// Gets or sets the request
        /// </summary>
        /// <value>
        /// The request
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Request
        {
            get
            {
                return this.request;
            }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    this.request = value.Replace(@"encoding=""UTF-8""", @"encoding=""UTF-16""");
                }
                else
                {
                    this.request = value;
                }
            }
        }

        /// <summary>
        /// Gets or sets the response
        /// </summary>
        /// <value>
        /// The response
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Response
        {
            get
            {
                return this.response;
            }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    this.response = value.Replace(@"encoding=""UTF-8""", @"encoding=""UTF-16""");
                }
                else
                {
                    this.response = value;
                }
            }
        }

        /// <summary>
        /// Gets or sets the ServiceMessageRequestID
        /// </summary>
        /// <value>
        /// The ServiceMessageRequestID
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string ServiceMessageRequestID { get; set; }

        /// <summary>
        /// Gets or sets the ServiceMessageResponseID
        /// </summary>
        /// <value>
        /// The ServiceMessageResponseID
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string ServiceMessageResponseID { get; set; }

        /// <summary>
        /// Gets or sets the Sex Id
        /// </summary>
        /// <value>
        /// The Sex Id
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Sex { get; set; }
    }
}