﻿using System;
using System.Runtime.Serialization;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// Represents an attachment to a CDA document.
    /// The namespace of this class must stay as HIPS.PcehrSchemas for compatibility
    /// with the legacy PCEHRService that does not have separate DTO classes.
    /// </summary>
    [KnownType(typeof(Attachment))]
    [Serializable]
    [DataContract]
    public class Attachment
    {
        private byte[] contents;
        private string fileName;

        /// <summary>
        /// Gets or sets the contents of the attached file.
        /// </summary>
        [DataMember]
        public byte[] Contents
        {
            get
            {
                return contents;
            }
            set
            {
                contents = value;
            }
        }

        /// <summary>
        /// Gets or sets the name of the attached file. For example "XRAY.PNG" or "DOCUMENT.PDF".
        /// </summary>
        [DataMember]
        public string FileName
        {
            get
            {
                return fileName;
            }
            set
            {
                fileName = value;
            }
        }
    }
}