﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This object is used listing the “LocalClinicalDocumentMetaData” data for a patient.
    /// The PatientIdentifierBase class must be defined in the object before using
    /// </summary>
    [Serializable]
    [DataContract(Name = "LocalClinicalDocumentListResponse")]
    public class LocalClinicalDocumentListResponse<T> where T : PatientIdentifierBase
    {
        #region Private Members

        private IList<LocalClinicalDocumentMetaData> documentList = new List<LocalClinicalDocumentMetaData>();
        private HipsResponse hipsResponse = new HipsResponse(HipsResponseIndicator.SystemError, null);
        private T patientIdentifier;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the DocumentList IList.
        /// List of the Local Document Meta Data Items.
        /// </summary>
        /// <value>
        /// The DocumentList
        /// </value>
        [DataMember]
        public IList<LocalClinicalDocumentMetaData> DocumentList
        {
            get { return documentList; }
            set { documentList = value; }
        }

        /// <summary>
        /// Gets or sets the HipsResponse.
        /// Common Response Object.
        /// </summary>
        /// <value>
        /// The hipsResponse
        /// </value>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get { return hipsResponse; }
            set { hipsResponse = value; }
        }

        /// <summary>
        /// Gets or sets the PatientIdentifier.
        /// Patient Identifier Class that matches the same object that was used as the passed in PatientIdentifier Class.
        /// </summary>
        /// <value>
        /// The PatientIdentifier
        /// </value>
        [DataMember]
        public T PatientIdentifier
        {
            get { return patientIdentifier; }
            set { patientIdentifier = value; }
        }

        #endregion Properties
    }
}