﻿using System.Runtime.Serialization;
using HIPS.ServiceContracts.Common.DTO.PatientIdentifier;

namespace HIPS.ServiceContracts.Common.DTO
{
    /// <summary>
    /// Patient Participation Status DTO.
    /// </summary>
    public class PatientParticipationStatus
    {
        /// <summary>
        /// Gets or sets a code in the in the hospital code system that was specified in the service request,
        /// which identifies the hospital that allocated the MRN.
        /// </summary>
        [DataMember]
        public string HospitalCode { get; set; }

        /// <summary>
        /// Gets or sets a patient identifier unique within the hospital, typically allocated by the hospital’s PAS or PMI.
        /// </summary>
        [DataMember]
        public string Mrn { get; set; }

        /// <summary>
        /// Gets or sets the participation status.
        /// </summary>
        [DataMember]
        public ParticipationStatus ParticipationStatus { get; set; }

        /// <summary>
        /// Gets or sets a patient identifier unique within the state or territory and
        /// typically allocated by the enterprise master patient index.
        /// </summary>
        [DataMember]
        public string StatePatientId { get; set; }

        /// <summary>
        /// Gets or sets an Individual Healthcare Identifier (IHI) allocated by the national
        /// healthcare identifier service, and the information required to
        /// check the validity of the IHI.
        /// </summary>
        [DataMember]
        public ValidatedIhi ValidatedIhi { get; set; }
    }
}