﻿using System.Runtime.Serialization;
using HIPS.ServiceContracts.Common;
using HIPS.ServiceContracts.Common.DTO;
using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Hpii.DTO
{
    /// <summary>
    /// HPI-I Demographic Query DTO. This object represents a demographic search query.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.HPII_V2)]
    [EntLibVal.Validators.HasSelfValidation]
    public class DemographicQuery : Query
    {
        #region Properties

        /// <summary>
        /// Gets or sets the structured Australian address.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.IgnoreNulls]
        [EntLibVal.Validators.ObjectValidator]
        public StructuredAustralianAddress AustralianAddress { get; set; }

        /// <summary>
        /// Gets or sets the international address.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.IgnoreNulls]
        [EntLibVal.Validators.ObjectValidator]
        public InternationalAddress InternationalAddress { get; set; }

        #endregion Properties

        #region Methods

        /// <summary>
        /// Validate the instance is valid.
        /// </summary>
        /// <param name="results">Validation results to add results of validation to.</param>
        [EntLibVal.Validators.SelfValidation]
        protected new void Validate(EntLibVal.ValidationResults results)
        {
            if (this.DateOfBirth == null)
            {
                results.AddResult(new EntLibVal.ValidationResult("Must contain date of birth.", this, "DemographicQuery", string.Empty, null));
            }
            
            if (this.Sex == null || this.Sex.Value == Common.Sex.None)
            {
                results.AddResult(new EntLibVal.ValidationResult("Must contain sex.", this, "DemographicQuery", string.Empty, null));
            }

            if (this.AustralianAddress != null)
            {
                if (this.InternationalAddress != null)
                {
                    results.AddResult(new EntLibVal.ValidationResult("Must not contain both Australian and international address criteria.", this, "DemographicQuery", string.Empty, null));
                }
            }
            else
            {
                if (this.InternationalAddress == null)
                {
                    results.AddResult(new EntLibVal.ValidationResult("Must contain either Australian or international address criteria.", this, "DemographicQuery", string.Empty, null));
                }
            }
        }

        #endregion Methods
    }
}