﻿#region Using Directives

using System;
using System.ServiceModel;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.IhiSchemas.Schemas;

#endregion Using Directives

namespace HIPS.ServiceContracts.ServiceInterfaces
{
    /// <summary>
    /// Web service interface for the IHI service.
    /// </summary>
    [WCFExtras.Wsdl.Documentation.XmlComments]
    [ServiceContract(Namespace = "http://schemas.HIPS/Services/2012/01", Name = "IHIService")]
    public interface IIHIService
    {
        /// <summary>
        /// Obtains validated IHI information for use in a clinical document.
        /// </summary>
        /// <param name="patientIdentifier">Patient identifier (Hospital-level MRN, State Patient ID, Validated IHI or PCEHR Data Store PatientMasterId)</param>
        /// <param name="dateOfBirth">Patient's date of birth (for identity verification)</param>
        /// <param name="user">The user responsible for this action</param>
        /// <returns>Validated IHI information</returns>
        [OperationContract]
        ValidatedIhiResponse GetValidatedIhi(PatientIdentifierBase patientIdentifier, DateTime dateOfBirth, UserDetails user);
    }
}