﻿using System.Configuration;
using HIPS.Client.Proxy;

namespace Test.CommonCcaNoc.Helpers
{
    /// <summary>
    /// Provides service proxies for use in CCA testing.
    /// </summary>
    public class ProxyHelper
    {
        #region Public Properties
        
        public static IHIProxy IhiProxy
        {
            get
            {
                return new IHIProxy(string.Format("{0}_IHIService", EnvironmentUnderTest));
            }
        }

        public static HpiiProxy HpiiProxy
        {
            get
            {
                return new HpiiProxy(string.Format("{0}_HpiiService", EnvironmentUnderTest));
            }
        }

        public static PCEHRProxy PcehrProxy
        {
            get
            {
                return new PCEHRProxy(string.Format("{0}_PCEHRService", EnvironmentUnderTest));
            }
        }

        public static PcehrServiceV2Proxy PcehrServiceV2Proxy
        {
            get
            {
                return new PcehrServiceV2Proxy(string.Format("{0}_PcehrServiceV2Proxy", EnvironmentUnderTest));
            }
        }


        public static ConsentProxy ConsentProxy
        {
            get
            {
                return new ConsentProxy(string.Format("{0}_ConsentService", EnvironmentUnderTest));
            }
        }

        public static ReferenceProxy ReferenceProxy
        {
            get
            {
                return new ReferenceProxy(string.Format("{0}_ReferenceService", EnvironmentUnderTest));
            }
        }

        public static AssistedRegistrationProxy AssistedRegistrationProxy
        {
            get
            {
                return new AssistedRegistrationProxy(string.Format("{0}_AssistedRegistrationService", EnvironmentUnderTest));
            }
        }
        
        public static CdaProxy CdaProxy
        {
            get
            {
                return new CdaProxy(string.Format("{0}_CdaService", EnvironmentUnderTest));
            }
        }

        public static HpiiServiceV2Proxy HpiiServiceV2Proxy
        {
            get
            {
                return new HpiiServiceV2Proxy(string.Format("{0}_HpiiServiceV2", EnvironmentUnderTest));
            }
        }

        public static PatientServiceV2Proxy PatientServiceV2Proxy
        {
            get
            {
                return new PatientServiceV2Proxy(string.Format("{0}_PatientServiceV2", EnvironmentUnderTest));
            }
        }

        #endregion Public Properties

        #region Private Properties

        public static string EnvironmentUnderTest
        {
            get
            {
                return ConfigurationManager.AppSettings["EnvironmentUnderTest"].ToString();
            }
        }

        #endregion Private Properties

    }
}