﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text.RegularExpressions;
using System.Xml;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.CdaPackaging.eSignature
{
    /// <summary>
    /// Conformance Test Specification: CDA Rendering (Authoring Component)
    ///                                 Version 1.3 — 12 September 2012
    /// Schedule Name:	Authoring Systems
    /// Group:          Authoring Requirements for CDA Header
    /// </summary>
    [TestClass]
    public class CdaAuthoring_1A : CcaTest
    {
        private CdaDocument cdaDocument;
        private CdaSignature cdaSignature;

        /// <summary>
        /// Shared helper method to ensure that a document has been uploaded
        /// and get the CDA Signature.
        /// The document will be reused between the tests in this class.
        /// </summary>
        private void UploadDocument()
        {
            SharedPackage shared = SharedPackage.GetSharedInstance1A(this, SampleDocumentType.DischargeSummary1A);
            this.cdaDocument = shared.CdaDocument;
            this.cdaSignature = shared.CdaSignature;
        }


        /// <summary>
        /// b. Verify that XML ID attribute values are unique in the document by searching each XML ID attribute 
        /// value and ensuring that there are not two or more identical values.
        /// </summary>
        [TestMethod]
        [TestCategory("CA_CCA_1A")]
        public void CdaAuthoring_1A_CDAR_AS_004b()
        {
            UploadDocument();

            List<XmlNode> nodes = new List<XmlNode>(cdaDocument.GetIdAttributes().Cast<XmlNode>());
            int distinctCount  = nodes.Distinct<XmlNode>().Count<XmlNode>();
            int idAttributeCount = nodes.Count<XmlNode>();
            
            LogAssert.AreEqual(idAttributeCount, distinctCount, DialogueResource.CountIdAttributesTotal, DialogueResource.CountIdAttributesDistinct);
        }

        /// <summary>
        /// a. Author a CDA document that contains a <title> header element, and verify that the <title> 
        /// header element is present in the CDA header
        /// </summary>
        [TestMethod]
        [TestCategory("CA_CCA_1A")]
        public void CdaAuthoring_1A_CDAR_AS_024a()
        {
            UploadDocument();
            XmlNode clinicalDocumentTitle = cdaDocument.GetClinicalDocumentTitle();
            LogAssert.AreEqual("Discharge Summary", clinicalDocumentTitle.Value, DialogueResource.DischargeSummaryClinicalDocumentTitle);
        }

        /// <summary>
        /// b. Verify that the authoring system generates the correct <templateID> element attribute 
        /// values as defined in the corresponding CDA IG. 
        /// </summary>
        [TestMethod]
        [TestCategory("CA_CCA_1A")]
        public void CdaAuthoring_1A_CDAR_AS_024b()
        {
            UploadDocument();
            XmlNodeList templateIds = cdaDocument.GetAllTemplateId();
            string cdaImplementationGuideRoot = templateIds.Item(0).Attributes["root"].Value;
            string cdaImplementationGuideExtension = templateIds.Item(0).Attributes["extension"].Value;

            string cdaRenderingSpecificationRoot  = templateIds.Item(1).Attributes["root"].Value;
            string cdaRenderingSpecificationExtension  = templateIds.Item(1).Attributes["extension"].Value;

            LogAssert.AreEqual(CdaDocument.CDA_IMPLEMENTATION_GUIDE_ROOT, cdaImplementationGuideRoot, DialogueResource.CdaImplementationGuideRoot);
            LogAssert.AreEqual(CdaDocument.CDA_IMPLEMENTATION_GUIDE_EXTENSION, cdaImplementationGuideExtension, DialogueResource.CdaRenderingSpecificationExtension);

            LogAssert.AreEqual(CdaDocument.CDA_RENDERING_SPECIFICATION_ROOT, cdaRenderingSpecificationRoot, DialogueResource.CdaRenderingSpecificationRoot);
            LogAssert.AreEqual(CdaDocument.CDA_RENDERING_SPECIFICATION_EXTENSION, cdaRenderingSpecificationExtension, DialogueResource.CdaRenderingSpecificationExtension);

        }

        /// <summary>
        /// c. Verify that the authoring system generates the correct code header element attribute 
        /// values as defined in the corresponding CDA IG. 
        /// </summary>
        [TestMethod]
        [TestCategory("CA_CCA_1A")]
        public void CdaAuthoring_1A_CDAR_AS_024c()
        {
            UploadDocument();
            XmlNode code = cdaDocument.GetDocumentCode();

            LogAssert.AreEqual("18842-5", code.Attributes["code"].Value, DialogueResource.DischargeSummaryCode);
            LogAssert.AreEqual("2.16.840.1.113883.6.1", code.Attributes["codeSystem"].Value, DialogueResource.DischargeSummaryCodeSystem);
            LogAssert.AreEqual("LOINC", code.Attributes["codeSystemName"].Value, DialogueResource.DischargeSummaryCodeSystemName);
            LogAssert.AreEqual("Discharge Summarization Note", code.Attributes["displayName"].Value, DialogueResource.DischargeSummaryCodeDisplayName);

        }



       
    }
}