﻿using HIPS.CommonSchemas;
using HIPS.PcehrSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_002_1
{
    /// <summary>
    /// Conformance Test Specification: Clinical Information Systems
    ///                                 Connecting to the PCEHR System
    ///                                 Version 1.6 — 27 September 2012
    /// Use Case #:	    UC.CIS.002.1
    /// Use Case Name:	Gain access to PCEHR (with Access Code)
    /// Test Case ID:   PCEHR_CIS_019048
    /// Objective:
    /// Software demonstrates the ability to provide the user with an option to
    /// enter provider access consent codes.
    ///
    /// Note: before running this test, ensure that you have set up the Record
    /// Access Code and Limited Document Access Code for your test patient and
    /// entered them into the app.config file.
    /// </summary>
    [TestClass]
    public class PCEHR_CIS_019048 : CcaTest
    {
        /// <summary>
        /// Request access to the PCEHR for a healthcare recipient whereby an
        /// access code must be entered to gain access to the record:
        /// a. Verify that the software provides the facility to enter a PACC
        ///    Code for that healthcare recipient's record.
        /// b. Verify that the software receives a successful response from the
        ///    PCEHR System.
        /// </summary>
        [TestMethod]
        [TestCategory("CIS_CCA_002_1")]
        public void CIS_0021_019048_AB()
        {
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "CCA ID IHI_93");
            GainPcehrAccessResponse response = ProxyHelper.PcehrProxy.GainAccessWithCode(patient.TargetPatientIdentifier, patient.TestPatientRecordAccessCode, patient.GetTestUser());
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, response.HipsResponse, DialogueResource.HipsServiceGainAccessWithCode);
        }

        /// <summary>
        /// Repeat the previous operation for the same subject:
        /// c. Verify that the software again provides the facility to enter
        ///    PACCX Code for that healthcare recipient's record.
        /// d. Verify that the software receives a successful response from the
        ///    PCEHR System.
        /// </summary>
        [TestMethod]
        [TestCategory("CIS_CCA_002_1")]
        public void CIS_0021_019048_CD()
        {
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "CCA ID IHI_93");
            GainPcehrAccessResponse response = ProxyHelper.PcehrProxy.GainAccessWithCode(patient.TargetPatientIdentifier, patient.TestPatientLimitedDocumentAccessCode, patient.GetTestUser());
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, response.HipsResponse, DialogueResource.HipsServiceGainAccessWithCode);
        }
    }
}