﻿using System.Text;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_203
{
    /// <summary>
    /// Conformance Test Specification: Clinical Information Systems Connecting to the PCEHR System
    ///                                 Version 1.6 — 27 September 2012
    /// Use Case #:	    UC.CIS.203
    /// Use Case Name:	Remove a Clinical Document
    /// Test Case ID:   PCEHR_CIS_019377
    /// Objective:
    /// To check that the Clinical Information System provides an ability to
    /// remove previously uploaded clinical documents where there is a change
    /// or an error in the data used to create the uploaded clinical documents.
    /// </summary>
    [TestClass]
    public class PCEHR_CIS_019377 : CcaTest
    {
        /// <summary>
        /// Create a clinical document for a healthcare recipient using the
        /// software, and perform the following steps:
        /// 1. Upload the document to the PCEHR System.
        /// 2. Remove the document from the PCEHR System.
        /// Now:
        /// a. Verify that steps 1 - 2 above can be performed without error.
        /// </summary>
        [TestMethod]
        [TestCategory("CIS_CCA_203")]
        public void CIS_203_019377_A()
        {
            // Create and upload the initial version of the document
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "CCA ID IHI_85");
            CdaDocument cdaDocument = patient.CreateNewDocument(SampleDocumentType.DischargeSummary3A);
            QueueHelper.UploadDocumentAndWaitUntilProcessed(patient, LogAssert, cdaDocument);

            // Perform an operation to remove the document from the PCEHR System.
            byte[] auditInformation = Encoding.UTF8.GetBytes("CIS_203_019377_A");
            HipsResponse response = ProxyHelper.PcehrProxy.Remove(patient.TargetPatientIdentifier, patient.TargetEpisode.AdmissionDate, cdaDocument.GetSetId(), RemovalReason.Withdrawn, patient.GetTestUser(), auditInformation);
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, response, "Remove");
            QueueHelper.WaitForQueuedOperation(patient, LogAssert, DialogueResource.RemoveWaitTimeout);
        }
    }
}