﻿using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;
using HIPS.PcehrSchemas;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using System.Xml;
using System.IO;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_502
{
    /// <summary>
    /// Conformance Test Specification: Clinical Information Systems Connecting to the PCEHR System
    ///                                 Version 1.6 — 7 March 2013
    /// Use Case #:	    UC.CIS.502
    /// Use Case Name:	Assisted Registration of an adult
    /// Test Case ID:   PCEHR_CIS_020218
    /// Objective:
    /// To assist a consumer with registering for an eHealth record. 
    /// </summary>
    //[TestClass]
    //public class PCEHR_CIS_020218 : CcaTest
    //{
    //    /// <summary>
    //    /// If the CIS does not use the coding system defined in the AIHW METeOR Standard for the purpose indicating the indigenous status of the consumer in the registration request, then;
    //    ///     1. Prepare registration details, complete all necessary form fields, and set the indigenous status to indicate that the consumer is “Aboriginal but not Torres Strait Islander origin”.
    //    ///         a. Submit the registration request
    //    ///         b. Verify the request sent to the eHealth system record contains an indigenous status code of '1'.
    //    /// </summary>
    //    [TestMethod]
    //    [TestCategory("CIS_CCA_502")]
    //    public void CIS_502_020218_1()
    //    {
    //        CreateRegistrationRequest(1, IndigenousStatus.AboriginalNotTorresStraitIslander);
    //    }

    //    /// <summary>
    //    /// If the CIS does not use the coding system defined in the AIHW METeOR Standard for the purpose indicating the indigenous status of the consumer in the registration request, then;
    //    ///     2. Prepare registration details, complete all necessary form fields, and set the indigenous status to indicate that the consumer is “Torres Strait Islander but not Aboriginal origin”.
    //    ///         a. Submit the registration request
    //    ///         b. Verify the request sent to the eHealth system record contains an indigenous status code of '2'.
    //    /// </summary>
    //    [TestMethod]
    //    [TestCategory("CIS_CCA_502")]
    //    public void CIS_502_020218_2()
    //    {
    //        CreateRegistrationRequest(2, IndigenousStatus.TorresStraitIslanderNotAboriginal);
    //    }

    //    /// <summary>
    //    /// If the CIS does not use the coding system defined in the AIHW METeOR Standard for the purpose indicating the indigenous status of the consumer in the registration request, then;
    //    ///     3. Prepare registration details, complete all necessary form fields, and set the indigenous status to indicate that the consumer is “Both Aboriginal and Torres Strait Islander origin”.
    //    ///         a. Submit the registration request
    //    ///         b. Verify the request sent to the eHealth system record contains an indigenous status code of '3'.
    //    /// </summary>
    //    [TestMethod]
    //    [TestCategory("CIS_CCA_502")]
    //    public void CIS_502_020218_3()
    //    {
    //        CreateRegistrationRequest(3, IndigenousStatus.BothAboriginalAndTorresStraitIslander);
    //    }

    //    /// <summary>
    //    /// If the CIS does not use the coding system defined in the AIHW METeOR Standard for the purpose indicating the indigenous status of the consumer in the registration request, then;
    //    ///     4. Prepare registration details, complete all necessary form fields, and set the indigenous status to indicate that the consumer is “Neither Aboriginal nor Torres Strait Islander origin”.
    //    ///         a. Submit the registration request
    //    ///         b. Verify the request sent to the eHealth system record contains an indigenous status code of '4'.
    //    /// </summary>
    //    [TestMethod]
    //    [TestCategory("CIS_CCA_502")]
    //    public void CIS_502_020218_4()
    //    {
    //        CreateRegistrationRequest(4, IndigenousStatus.NeitherAboriginalAndTorresStraitIslander);
    //    }

    //    /// <summary>
    //    /// If the CIS does not use the coding system defined in the AIHW METeOR Standard for the purpose indicating the indigenous status of the consumer in the registration request, then;
    //    ///     5. Prepare registration details, complete all necessary form fields, and set the indigenous status to indicate that the consumer is “Not stated/inadequately described”.
    //    ///         a. Submit the registration request
    //    ///         b. Verify the request sent to the eHealth system record contains an indigenous status code of '9'.
    //    /// </summary>
    //    [TestMethod]
    //    [TestCategory("CIS_CCA_502")]
    //    public void CIS_502_020218_5()
    //    {
    //        CreateRegistrationRequest(9, IndigenousStatus.NotStatedInadequatelyDescribed);
    //    }

    //    private void CreateRegistrationRequest(int statusCode, IndigenousStatus indigenousStatus)
    //    {
    //        patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "AR ID 14");

    //        // Representative with incorrect demographics
    //        CcaPatient patientRep = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "AR ID 13");

    //        // Create document consent list
    //        List<RegistrationDocumentConsent> documentConsentList = new List<RegistrationDocumentConsent>() { 
    //            new RegistrationDocumentConsent(RegistrationDocumentConsentType.ACIR, RegistrationDocumentConsentStatus.ConsentNotGiven),
    //            new RegistrationDocumentConsent(RegistrationDocumentConsentType.AODR, RegistrationDocumentConsentStatus.ConsentNotGiven),
    //            new RegistrationDocumentConsent(RegistrationDocumentConsentType.MBS, RegistrationDocumentConsentStatus.ConsentGiven),
    //            new RegistrationDocumentConsent(RegistrationDocumentConsentType.MBSPastAssimilation, RegistrationDocumentConsentStatus.ConsentNotGiven),
    //            new RegistrationDocumentConsent(RegistrationDocumentConsentType.PBS, RegistrationDocumentConsentStatus.ConsentNotGiven),
    //            new RegistrationDocumentConsent(RegistrationDocumentConsentType.PBSPastAssimilation, RegistrationDocumentConsentStatus.ConsentNotGiven),
    //        };

    //        // Create correspondence channel
    //        RegistrationCorrespondenceChannel channel = new RegistrationCorrespondenceChannel();
    //        channel.Channel = IvcCorrespondenceChannel.response;

    //        PcehrRegistrationResponse registrationResponse = ProxyHelper.AssistedRegistrationProxy.RegisterDependant(patient.TargetPatientIdentifier,
    //            patientRep.TargetDemographic,
    //            EvidenceOfIdentityType.IdentityVerificationMethod1,
    //            indigenousStatus,
    //            documentConsentList,
    //            channel,
    //            true,
    //            true,
    //            patient.GetTestUser());

    //        LogAssert.ExpectResponse(HipsResponseIndicator.PcehrServiceError, registrationResponse.HipsResponse, "Unexpected Validation Error");

    //        // Check that HIPS audited the request
    //        PcehrAudit pcehrAudit = patient.GetLastPcehrAudit("Register PCEHR");

    //        VerifyIndigenousStatusCode(pcehrAudit, statusCode);
    //    }

    //    private void VerifyIndigenousStatusCode(PcehrAudit audit, int statusCode)
    //    {
    //        // Confirm that the payload is well formed and complies with the gainPCEHRAccess Request XML Schema
    //        XmlDocument doc = new XmlDocument();
    //        using (StringReader sr = new StringReader(audit.Request))
    //        {
    //            doc.Load(sr);
    //        }
    //        XmlNamespaceManager nsmgr = new XmlNamespaceManager(new NameTable());
    //        nsmgr.AddNamespace("s", "http://www.w3.org/2003/05/soap-envelope");
    //        nsmgr.AddNamespace("p", "http://ns.electronichealth.net.au/pcehr/xsd/interfaces/RegisterPCEHR/2.0");
    //        nsmgr.AddNamespace("c", "http://ns.electronichealth.net.au/pcehr/xsd/common/CommonCoreElements/1.0");

    //        // Check that the patient ID was provided in the request
    //        XmlNode indigenousStatusNode = doc.SelectSingleNode("/s:Envelope/s:Body/p:registerPCEHR/p:assertions/p:identity/p:indigenousStatus", nsmgr);
    //        LogAssert.AreEqual(statusCode.ToString(), indigenousStatusNode.InnerText, "Indigenous status code doesn't match");

    //    }
    //}
}