﻿using System;
using System.IO;
using System.Linq;
using System.ServiceModel;
using System.Text;
using System.Windows.Forms;

using HIPS.Client.Proxy;
using dto = HIPS.ServiceContracts.Common.DTO;
using HIPS.ServiceContracts.Common;
using System.Collections.Generic;

namespace HIPS.DemoHarness
{
    public partial class DemoHarnessForm
    {
        PcehrServiceV2Proxy GetPcehrServiceV2Client()
        {
            string endpointConfigurationName = environmentComboBox.Text + "_PCEHRServiceV2";
            PcehrServiceV2Proxy client = new PcehrServiceV2Proxy(endpointConfigurationName);
            return client;
        }

        CdaProxy GetCdaClient()
        {
            string endpointConfigurationName = environmentComboBox.Text + "_CdaService";
            CdaProxy client = new CdaProxy(endpointConfigurationName);
            return client;
        }

        private void CreateDocAddAttachmentButton_Click(object sender, EventArgs e)
        {
            OpenFileDialog dialog = new OpenFileDialog();
            dialog.Filter = "PCEHR Supported Attachment|*.gif;*.jpg;*.jpeg;*.png;*.tif;*.tiff;*.pdf|Graphics Interchange Format|*.gif|Joint Photographic Experts Group|*.jpg;*.jpeg|Portable Network Graphics|*.png|Tagged Image File Format|*.tif;*.tiff|Portable Document Format|*.pdf";
            DialogResult result = dialog.ShowDialog(this);
            if (result == DialogResult.OK)
            {
                foreach (string path in dialog.FileNames)
                {
                    Attachment attachment = new Attachment() { FilePath = path };
                    CreateDocAttachmentBindingSource.Add(attachment);
                }
            }
        }

        private void CreateDocRemoveAttachmentButton_Click(object sender, EventArgs e)
        {
            if (CreateDocAttachmentBindingSource.Current != null)
            {
                CreateDocAttachmentBindingSource.RemoveCurrent();
            }
        }

        private void CreateDocCreateCdaDocumentButton_Click(object sender, EventArgs e)
        {
            CreateDischargeSummaryLevel1A(uploadToPcehr: false);
        }

        private void CreateDischargeSummaryLevel1A(bool uploadToPcehr)
        {
            // Put all the information in these objects
            var userDetails = GetUser();
            dto.UserIdentity.LocalUser user = new dto.UserIdentity.LocalUser()
            {
             
                Domain = userDetails.Domain,
                Login = userDetails.Login,
                FamilyName = userDetails.Name.Split(' ').Last(),
                GivenNames = userDetails.Name.Split(' ').First()
            };

            dto.PatientIdentifier.Mrn patientIdentifier = new dto.PatientIdentifier.Mrn()
            {
                Value = GetSelectedPatientMrn(),
                HospitalCode = GetSelectedPatientHospitalCode(),
                HospitalCodeSystem = GetHospitalCodeSystem()
            };

            var documentAuthorLocalVar = new dto.ParticipatingIndividual.ParticipatingProvider()
            {
                FamilyName = CreateDocAuthorFamilyNameTextBox.Text,
                GivenNames = CreateDocAuthorGivenNameTextBox.Text,
                Hpii = CreateDocTypeRadioButton1.Checked ? CreateDocAuthorLocalIdentifierTextBox.Text : null,
                Title = string.IsNullOrEmpty(CreateDocAuthorTitleTextBox.Text) ? null : CreateDocAuthorTitleTextBox.Text,
                Suffix = string.IsNullOrEmpty(CreateDocAuthorSuffixTextBox.Text) ? null : CreateDocAuthorSuffixTextBox.Text,
                LocalIdentifier = CreateDocTypeRadioButton2.Checked ? CreateDocAuthorLocalIdentifierTextBox.Text : null
            };

            dto.CdaHeaderMetadata metadata = new dto.CdaHeaderMetadata()
            {
                AdmissionDateTime = CreateDocAdmissionDateTimePicker.Value,
                DischargeDateTime = CreateDocDischargeDateTimePicker.Value,
                DocumentAuthor = documentAuthorLocalVar,
                DocumentCreationDateTime = CreateDocCreationDateTimePicker.Value,
                LegalAuthenticator = documentAuthorLocalVar,
                ModeOfSeparation = (CreateDocModeOfSeparationComboBox.SelectedItem as SelectListItem<HIPS.ServiceContracts.Common.ModeOfSeparation>).EnumValue,
                ResponsibleHealthProfessional = documentAuthorLocalVar,
                SourceDocumentStatus = (CreateDocDocumentStatusComboBox.SelectedItem as SelectListItem<HIPS.ServiceContracts.Common.SourceDocumentStatus>).EnumValue,
                Specialty = CreateDocSpecialtyTextBox.Text
            };

            int numAttachments = attachmentBindingSource.Count;
            dto.CdaAttachment[] attachments = new dto.CdaAttachment[numAttachments];

            for (int i = 0; i < numAttachments; i++)
            {
                Attachment attachment = attachmentBindingSource[i] as Attachment;
                attachments[i] = new dto.CdaAttachment()
                {
                    FileName = attachment.FileName,
                    Content = attachment.Contents,
                    Caption = attachment.FileName,
                };
                string extension = new FileInfo(attachment.FileName).Extension;
                switch (extension)
                {
                    case "png":
                        attachments[i].AttachmentType = AttachmentType.AttachedImagePng;
                        break;
                    case "gif":
                        attachments[i].AttachmentType = AttachmentType.AttachedImageGif;
                        break;
                    case "jpg":
                    case "jpeg":
                        attachments[i].AttachmentType = AttachmentType.AttachedImageJpeg;
                        break;
                    case "tif":
                    case "tiff":
                        attachments[i].AttachmentType = AttachmentType.AttachedImageTiff;
                        break;
                    case "pdf":
                        attachments[i].AttachmentType = AttachmentType.AttachedDocumentPdf;
                        break;
                    default:
                        attachments[i].AttachmentType = AttachmentType.None;
                        break;
                }

            }


            byte[] pdfDocument = this.CreateDocDocument.Contents;

            try
            {
                // Call the method
                ResponseStatus status;
                List<dto.Message> messages;
                dto.CdaDocumentDetails data;
                if (uploadToPcehr)
                {
                    HIPS.Client.Proxy.PcehrServiceV2Proxy client = GetPcehrServiceV2Client();
                    var response = client.UploadOrSupersedeDischargeSummaryLevel1A(
                        new ServiceContracts.Pcehr.Message.UploadDischargeSummaryLevel1ARequest
                        {
                            User = user,
                            PdfDocument = pdfDocument,
                            PatientIdentifier = patientIdentifier,
                            CdaHeaderMetadata = metadata,
                            Attachments = attachments.ToList(),
                        });
                    status = response.Status;
                    messages = response.Messages;
                    data = response.Data;
                }
                else
                {
                    HIPS.Client.Proxy.CdaProxy client = GetCdaClient();
                    var response = client.CreateDischargeSummaryLevel1A(
                        new ServiceContracts.Cda.Message.CreateDischargeSummaryLevel1ARequest
                        {
                            User = user,
                            PdfDocument = pdfDocument,
                            PatientIdentifier = patientIdentifier,
                            CdaHeaderMetadata = metadata,
                            Attachments = attachments.ToList(),
                        });
                    status = response.Status;
                    messages = response.Messages;
                    data = response.Data;
                }

                // Display the status, messages and data.
                StringBuilder sb = new StringBuilder();
                sb.AppendLine(string.Format("Status: {0}", status));
                foreach (var message in messages)
                {
                    sb.AppendLine(string.Format("Message: {0}", message.Description));
                }
                sb.AppendLine(string.Format("Document ID: {0}", data.DocumentId));
                sb.AppendLine(string.Format("Document Set ID: {0}", data.DocumentSetId));

                CreateDocStatusTextBox.Text = sb.ToString();
            }
            catch (FaultException<HIPS.ServiceContracts.Common.Fault.InvalidRequestFault> ex)
            {
                // Display the messages
                StringBuilder sb = new StringBuilder();
                sb.AppendLine(string.Format("Message: {0}", ex.Detail.Message));
                foreach (var message in ex.Detail.Messages)
                {
                    sb.AppendLine(string.Format("Message: {0}", message.Description));
                }
                CreateDocStatusTextBox.Text = sb.ToString();
            }
            catch (FaultException<HIPS.ServiceContracts.Common.Fault.ServiceOperationFault> ex)
            {
                // Display the message
                StringBuilder sb = new StringBuilder();
                sb.AppendLine(string.Format("Message: {0}", ex.Detail.Message));
                CreateDocStatusTextBox.Text = sb.ToString();
            }
        }

        private void CreateDocCreateAndUploadButton_Click(object sender, EventArgs e)
        {
            CreateDischargeSummaryLevel1A(uploadToPcehr: true);
        }

        private void CreateDocSelectDocumentButton_Click(object sender, EventArgs e)
        {
            OpenFileDialog dialog = new OpenFileDialog();
            dialog.Filter = "PDF Document (*.pdf)|*.pdf";
            DialogResult result = dialog.ShowDialog(this);
            if (result == DialogResult.OK)
            {
                try
                {
                    this.CreateDocDocument = new Attachment();
                    this.CreateDocDocument.FilePath = dialog.FileName;
                    CreateDocDocumentTextBox.Text = string.Format(
                        "{0} ({1} bytes)",
                        this.CreateDocDocument.FileName,
                        this.CreateDocDocument.FileSize);
                    CreateDocCreateCdaDocumentButton.Enabled = true;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
            }
        }
    }
}
