﻿using System;
using System.Windows.Forms;

using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.DemoHarness
{
    public partial class DemoHarnessForm
    {
        private void RemoveButton_Click(object sender, EventArgs e)
        {
            DateTime submittedTime = DateTime.Now.AddSeconds(-4);
            RemoveServiceMessagesTextBox.Visible = false;
            RemoveServiceMessagesTextBox.Text = "";

            this.Cursor = Cursors.WaitCursor;
            var client = GetPcehrServiceClient();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string codingSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                DateTime admissionDate = SelectedEpisode.AdmissionDate;
                UserDetails user = GetUser();
                RemovalReason reason = (RemovalReason)RemoveReasonComboBox.SelectedItem;
                string documentSetId = RemoveDocumentComboBox.SelectedValue as string;

                HipsResponse response = client.Remove(new Mrn(mrn, hospitalCode, codingSystem), admissionDate, documentSetId, reason, user, null);

                RemoveErrorIndicatorTextBox.Text = response.ToString();

                SetAuditResults(submittedTime);
            }
            catch (Exception ex)
            {
                ShowException(ex, RemoveServiceMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        private void RemoveReasonComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            ClearResults();
            RemoveReasonTextBox.Text = RemoveReasonComboBox.Text;
        }

        private void RemoveDocumentComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            ClearResults();
            RemoveSetIdTextBox.Text = RemoveDocumentComboBox.SelectedValue as string;
        }

        private void RemoveEpisodeComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            ClearResults();
            string admissionDate = string.Format("{0:dd/MM/yyyy HH:mm:ss}", SelectedEpisode.AdmissionDate);
            RemoveAdmissionDateTextBox.Text = admissionDate;
            RemoveHospitalCodeTextBox.Text = GetSelectedPatientHospitalCode();
            RemoveMrnTextBox.Text = GetSelectedPatientMrn();

            this.documents = null;
            RemoveDocumentComboBox.Text = "";
            RemoveDocumentComboBox.DataSource = Documents;
            RemoveDocumentComboBox.DisplayMember = "SourceSystemSetId";
            RemoveDocumentComboBox.ValueMember = "SourceSystemSetId";

            RemoveButton.Enabled = documents.Count > 0;
        }

        private void RemovePatientComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            ClearResults();
            RemoveHospitalCodeTextBox.Text = GetSelectedPatientHospitalCode();
            RemoveMrnTextBox.Text = GetSelectedPatientMrn();
            RemoveHospitalCodeSystemTextBox.Text = GetHospitalCodeSystem();

            this.episodes = null;
            RemoveEpisodeComboBox.Text = "";
            RemoveDocumentComboBox.Text = "";
            RemoveDocumentComboBox.DataSource = null;
            RemoveEpisodeComboBox.DataSource = Episodes;
            RemoveEpisodeComboBox.DisplayMember = "AdmissionDate";
            RemoveEpisodeComboBox.ValueMember = "AdmissionDate";

            RemoveButton.Enabled = Documents.Count > 0;
        }

        private void RemovePcehrAuditGridView_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            AnyAuditDataGridViewClick(sender, e);
        }
    }
}
