﻿using System.ServiceModel;
using HIPS.CommonBusinessLogic.Pcehr;
using HIPS.PcehrSchemas;
using HIPS.ServiceContracts.ServiceInterfaces;

namespace HIPS.AppServer.ServiceHost
{
    [ServiceBehavior(InstanceContextMode = InstanceContextMode.Single,
                     ConcurrencyMode = ConcurrencyMode.Single,
                     ReleaseServiceInstanceOnTransactionComplete = false,
                     TransactionAutoCompleteOnSessionClose = false)]
    public class PcehrQueue : BaseService, IPcehrQueueInterface
    {
        [OperationBehavior(TransactionScopeRequired = true, TransactionAutoComplete = true)]
        public void SendRemoveRequest(QueuedRemoveOperation message)
        {
            DocumentRemoval dr = new DocumentRemoval(message);
            dr.Remove();
        }

        [OperationBehavior(TransactionScopeRequired = true, TransactionAutoComplete = true)]
        public void SendUploadRequest(QueuedUploadOperation message)
        {
            DocumentUpload du = new DocumentUpload(message);
            du.PerformUpload();
        }
    }
}