﻿namespace HIPS.Base.Schemas.Enumerators
{
    /// <summary>
    /// The method of contact details. The integer value links back to the ContactMethod table.
    /// </summary>
    public enum ContactMethods
    {
        /// <summary>
        /// Home phone number.
        /// </summary>
        HomePhone = 1,

        /// <summary>
        /// Home fax number.
        /// </summary>
        HomeFax = 2,

        /// <summary>
        /// Personal mobile phone number.
        /// </summary>
        PersonalMobile = 3,

        /// <summary>
        /// Personal email address.
        /// </summary>
        PersonalEmail = 4,

        /// <summary>
        /// Pager number.
        /// </summary>
        Pager = 5,

        /// <summary>
        /// Work phone number.
        /// </summary>
        WorkPhone = 6,

        /// <summary>
        /// Work fax number.
        /// </summary>
        WorkFax = 7,

        /// <summary>
        /// Work mobile phone number.
        /// </summary>
        WorkMobile = 8,

        /// <summary>
        /// Work email address.
        /// </summary>
        WorkEmail = 9
    }

    /// <summary>
    /// Represents a database column type. Affects whether the property is passed as
    /// a parameter into various types of stored procedures (insert, update or delete).
    /// </summary>
    public enum DatabaseColumnType
    {
        /// <summary>
        /// This property is an Auto-Increment column in SQL. Does not get passed as a parameter into Insert Statements. (Update, Delete)
        /// </summary>
        AutoGeneratedKey,

        /// <summary>
        /// This property forms part of the objects key, but is generated by the application and is passed through to All sprocs (Insert, Update, Delete)
        /// </summary>
        ApplicationGeneratedKey,

        /// <summary>
        /// This property is pure data only (Insert, Update)
        /// </summary>
        Data,

        /// <summary>
        /// This property is data, but only passed through to Update Sprocs (Update)
        /// </summary>
        UpdateData,

        /// <summary>
        /// This property is data, but get passed through to Update and Delete Sprocs (Update, Delete)
        /// </summary>
        UpdateDeleteData,

        /// <summary>
        /// This property is additional read-only data that should never be passed through to stored procedures.
        /// </summary>
        ReadOnlyData,
    }

    /// <summary>
    /// The type of name. The integer value links back to the NameType table.
    /// </summary>
    public enum NameTypes
    {
        /// <summary>
        /// The legal name registered with the Healthcare Identifier service.
        /// </summary>
        Legal = 1,

        /// <summary>
        /// The current preferred name in the local PAS system.
        /// </summary>
        Current = 2,

        /// <summary>
        /// A previous name in the local PAS system.
        /// </summary>
        Previous = 3
    }

    /// <summary>
    /// Represents a PUMA security group. Not used in HIPS.
    /// </summary>
    public enum SecurityGroup
    {
        /// <summary>
        /// No security group.
        /// </summary>
        None,

        /// <summary>
        /// Security group with permission to administer the system.
        /// </summary>
        Admin,

        /// <summary>
        /// Security group with permission to read discharge summaries.
        /// </summary>
        Read,

        /// <summary>
        /// Security group with permission to write discharge summaries.
        /// </summary>
        Write,

        /// <summary>
        /// Security group with permission to finalise discharge summaries.
        /// </summary>
        Finalise
    }
}