﻿#region Using Directives

using System.ServiceModel;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PatientSchemas;
using HIPS.ServiceContracts.ServiceInterfaces;

#endregion Using Directives

namespace HIPS.Client.Proxy
{
    /// <summary>
    /// This pre-built client class can be referenced by a .net client application in lieu of generating client classes from the WSDL.
    /// </summary>
    public class PatientProxy : ClientBase<IPatientService>, IPatientService
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="PatientProxy" /> class.
        /// </summary>
        /// <param name="endpointName">Configured endpoint name.</param>
        public PatientProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Lists the episodes for a specific patient in a defined hospital
        /// </summary>
        /// <param name="user">Information to identify the person responsible for this action</param>
        /// <param name="sourceSystemEpisodeId">The source system episode identifier for the episode in the hospital</param>
        /// <param name="patientIdentifier">The local, state or national patient identifier</param>
        /// <returns>
        /// Response containing the a list of the admitted or discharged episodes for the patient with in the specified number of days.,
        /// </returns>
        public EpisodePatientDetailsResponse GetEpisodeDetails(UserDetails user, string sourceSystemEpisodeId, PatientIdentifierBase patientIdentifier)
        {
            return Channel.GetEpisodeDetails(user, sourceSystemEpisodeId, patientIdentifier);
        }

        /// <summary>
        /// Gets the details of the patient’s discloser record for a specific HPIO
        /// </summary>
        /// <param name="user">Information to identify the person responsible for this action</param>
        /// <param name="patientIdentifier">The local, state or national patient identifier</param>
        /// <returns>
        /// Response containing the details of the patient's disclosure.
        /// </returns>
        public PatientDisclosureDetailsResponse GetPatientDisclosureDetails(UserDetails user, PatientIdentifierBase patientIdentifier)
        {
            return Channel.GetPatientDisclosureDetails(user, patientIdentifier);
        }

        /// <summary>
        /// Lists admitted or recently discharged patients in hospital.
        /// </summary>
        /// <param name="user">The user who is requesting the information.</param>
        /// <param name="hospitalCodeSystem">The hospital code system.</param>
        /// <param name="hospitalCode">The hospital code.</param>
        /// <param name="daysDischarged">Number of days after discharge that patients are included in the list. Set to 0 to list only currently admitted patients.</param>
        /// <returns>A patient list response with status and a list of patients in hospital.</returns>
        public AdmittedPatientListResponse ListAdmittedPatients(string hospitalCodeSystem, string hospitalCode, bool? withIhi, bool? withPcehr, bool excludeMedicareExclusions, int daysDischarged, UserDetails user)
        {
            return Channel.ListAdmittedPatients(hospitalCodeSystem, hospitalCode, withIhi, withPcehr, excludeMedicareExclusions, daysDischarged, user);
        }

        /// <summary>
        /// Lists the episodes for a specific patient in a defined hospital
        /// </summary>
        /// <param name="patientIdentifier">The local, state or national patient identifier</param>
        /// <param name="user">Information to identify the person responsible for this action</param>
        /// <returns>
        /// Response containing the a list of the admitted or discharged episodes for the patient with in the specified number of days.,
        /// </returns>
        public PatientEpisodeListResponse ListPatientEpisodesInHospital(UserDetails user, PatientIdentifierBase patientIdentifier, int daysDischarged)
        {
            return Channel.ListPatientEpisodesInHospital(user, patientIdentifier, daysDischarged);
        }

        /// <summary>
        /// Lists admitted or recently discharged patients, who have an active
        /// IHI, with or without a PCEHR.
        /// </summary>
        /// <param name="user">The name and identifier of the person who is
        ///     responsible for this action, typically the user who is operating
        ///     the application (required).</param>
        /// <param name="hospitalCodeSystem">The hospital code system (required).
        ///     This parameter filters which hospitals and codes are returned.</param>
        /// <param name="hospitalCode">The hospital code (optional). Send null
        ///     to include all hospitals that have a code in the code system.</param>
        /// <param name="withPcehr">True to list patients with a PCEHR, false
        ///     to list patients without a PCEHR. Null to include patients with
        ///     or without a PCEHR.</param>
        /// <param name="daysDischarged">Number of days after discharge that
        ///     patients are included in the list. Set to 0 to list only
        ///     currently admitted patients.</param>
        /// <returns>A patient list response with status and a list of patients in hospital.</returns>
        public PatientListResponse ListPatientsInHospital(UserDetails user, string hospitalCodeSystem, string hospitalCode, bool? withPcehr, int daysDischarged)
        {
            return Channel.ListPatientsInHospital(user, hospitalCodeSystem, hospitalCode, withPcehr, daysDischarged);
        }

        /// <summary>
        /// Lists admitted or recently discharged patients in hospital without an IHI.
        /// </summary>
        /// <param name="user">The user who is requesting the information.</param>
        /// <param name="hospitalCodeSystem">The hospital code system.</param>
        /// <param name="hospitalCode">The hospital code.</param>
        /// <param name="daysDischarged">Number of days after discharge that patients are included in the list. Set to 0 to list only currently admitted patients.</param>
        /// <returns>A patient list response with status and a list of patients in hospital.</returns>
        //public PatientListResponse ListPatientsWithoutIhi(UserDetails user, string hospitalCodeSystem, string hospitalCode, int daysDischarged)
        //{
        //    return Channel.ListPatientsWithoutIhi(user, hospitalCodeSystem, hospitalCode, daysDischarged);
        //}
    }
}