﻿namespace HIPS.CommonSchemas.Cda.ParticipatingIndividual
{
    /// <summary>
    /// Participating Individual model. This object contains information that identifies
    /// the person who is the 'Author', 'Legal Authenticator' and 'Responsible Health
    /// Professional at time of discharge' for the document, and the organisation for
    /// which they are working in the context of this document.
    /// </summary>
    public class ParticipatingProvider : ParticipatingIndividual
    {
        #region Properties

        /// <summary>
        /// Gets or sets the HPI-O of the organisation that employs the participant.
        /// </summary>
        public string EmployerHpio { get; set; }

        /// <summary>
        /// Gets or sets the name of the organisation that employs the participant.
        /// </summary>
        public string EmployerName { get; set; }

        /// <summary>
        /// Gets or sets the validated HPI-I of the participant. This is conditionally
        /// mandatory with the Local Identifier as at least one must be specified.
        /// If both are specified then the HPI-I will take precedence over the
        /// Local Identifier.
        /// </summary>
        public string Hpii { get; set; }

        #endregion Properties
    }
}