﻿using System;

namespace HIPS.CommonSchemas.Exceptions
{
    /// <summary>
    /// Indicates an error returned by the HI Service.
    /// </summary>
    public class HiServiceException : Exception
    {
        /// <summary>
        /// Creates an exception indicating an error returned by the HI Service.
        /// </summary>
        /// <param name="response">The HIPS response from the HI business logic.</param>
        public HiServiceException(HipsResponse response)
            : base(response.HipsErrorMessage)
        {
            this.ResponseCode = response.ResponseCode;
            this.ResponseCodeDescription = response.ResponseCodeDescription;
            this.ResponseCodeDetails = response.ResponseCodeDetails;
        }

        /// <summary>
        /// Gets the HI Service response code.
        /// </summary>
        public string ResponseCode { get; internal set; }

        /// <summary>
        /// Gets the HI Service response code description.
        /// </summary>
        public string ResponseCodeDescription { get; internal set; }

        /// <summary>
        /// Gets the HI Service response code details.
        /// </summary>
        public string ResponseCodeDetails { get; internal set; }
    }
}