﻿using System.Collections.Generic;
using System.Runtime.Serialization;

namespace HIPS.CommonSchemas
{
    /// <summary>
    /// Standardised HIPS Response Message
    /// </summary>

    [KnownType(typeof(HipsResponseList))]
    [DataContract]
    public class HipsResponseList
    {
        #region Private Members

        private List<HipsResponse> responses;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the HipsResponseList
        /// </summary>
        /// <value>
        /// The hipsResponseList
        /// </value>
        public List<HipsResponse> Responses
        {
            get { return responses; }
            set { responses = value; }
        }

        #endregion Properties

        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="HipsResponseList"/> class.
        /// </summary>
        public HipsResponseList()
        {
            responses = new List<HipsResponse>();
        }

        #endregion Constructors
    }
}