﻿using System;
using System.Runtime.Serialization;
using HIPS.CommonSchemas.PatientIdentifier;

namespace HIPS.ConsentSchemas
{
    /// <summary>
    /// The information in this class represents the current PCEHR participation
    /// status for a patient. It holds all the information required for the
    /// calling system to identify the patient record, including the MRN, the
    /// state patient identifier and the validated IHI.
    /// </summary>
    [KnownType(typeof(PatientParticipationStatus))]
    [Serializable]
    [DataContract]
    public class PatientParticipationStatus
    {
        private string hospitalCodeField;
        private string mrnField;
        private ParticipationStatus participationStatusField;
        private string statePatientIdField;
        private ValidatedIhi validatedIhiField;

        /// <summary>
        /// A code in the in the hospital code system that was specified in the service request,
        /// which identifies the hospital that allocated the MRN.
        /// </summary>
        [DataMember]
        public string HospitalCode
        {
            get
            {
                return hospitalCodeField;
            }
            set
            {
                hospitalCodeField = value;
            }
        }

        /// <summary>
        /// A patient identifier unique within the hospital, typically allocated by the hospital’s PAS or PMI.
        /// </summary>
        [DataMember]
        public string Mrn
        {
            get
            {
                return mrnField;
            }
            set
            {
                mrnField = value;
            }
        }

        /// <summary>
        /// Gets or sets the current participation status of the patient.
        /// </summary>
        [DataMember]
        public ParticipationStatus ParticipationStatus
        {
            get
            {
                return participationStatusField;
            }
            set
            {
                participationStatusField = value;
            }
        }

        /// <summary>
        /// Gets or sets a patient identifier unique within the state or territory and
        /// typically allocated by the enterprise master patient index.
        /// </summary>
        [DataMember]
        public string StatePatientId
        {
            get { return statePatientIdField; }
            set { statePatientIdField = value; }
        }

        /// <summary>
        /// Gets or sets an Individual Healthcare Identifier (IHI) allocated by the national
        /// healthcare identifier service, and the information required to
        /// check the validity of the IHI.
        /// </summary>
        [DataMember]
        public ValidatedIhi ValidatedIhi
        {
            get { return validatedIhiField; }
            set { validatedIhiField = value; }
        }
    }
}