﻿using System;
using System.Runtime.Serialization;

namespace HIPS.HpiiSchemas
{
    /// <summary>
    /// This class is used for the Batch Asynchronous Retrieval Response for individual items from the retrieve
    /// of the HPI-I batch Queries for identifier and demographic searches
    /// </summary>

    [KnownType(typeof(HpiiBatchQueryResponse))]
    [KnownType(typeof(HpiiQueryResponse))]
    [Serializable]
    [DataContract]
    public class HpiiBatchQueryResponse
    {
        #region Private Members

        private HpiiQueryResponse hpiiQueryResponse;
        private string requestIdentifier;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the HpiiQueryResponse
        /// </summary>
        /// <value>
        /// The hpiiQueryResponse
        /// </value>
        public HpiiQueryResponse HpiiQueryResponse
        {
            get { return hpiiQueryResponse; }
            set { hpiiQueryResponse = value; }
        }

        /// <summary>
        /// Gets or sets the RequestIdentifier
        /// </summary>
        /// <value>
        /// The requestIdentifier
        /// </value>
        [DataMember]
        public string RequestIdentifier
        {
            get { return requestIdentifier; }
            set { requestIdentifier = value; }
        }

        #endregion Properties
    }
}