﻿using System;
using System.Runtime.Serialization;
using nehta.mcaR50.ProviderSearchForProviderIndividual;

namespace HIPS.HpiiSchemas
{
    /// <summary>
    /// This abtract class is used for the base of the HPI-I Queries for identifier and demographic searches
    /// </summary>

    [KnownType(typeof(HpiiQuery))]
    [Serializable]
    [DataContract]
    public abstract class HpiiQuery
    {
        #region Private Members

        private DateTime? dateOfBirth;
        private string familyName;
        private string[] givenName;
        private string hpioNumber;
        private bool onlyNameIndicator;
        private SexType? sex;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the DateofBirth
        /// </summary>
        /// <value>
        /// The dateOfBirth
        /// </value>
        [DataMember]
        public DateTime? DateofBirth
        {
            get { return dateOfBirth; }
            set { dateOfBirth = value; }
        }

        /// <summary>
        /// Gets or sets the FamilyName
        /// </summary>
        /// <value>
        /// The familyName
        /// </value>
        [DataMember]
        public string FamilyName
        {
            get { return familyName; }
            set { familyName = value; }
        }

        /// <summary>
        /// Gets or sets the GivenName
        /// </summary>
        /// <value>
        /// The givenName
        /// </value>
        [DataMember]
        public string[] GivenName
        {
            get { return givenName; }
            set { givenName = value; }
        }

        /// <summary>
        /// Gets or sets the HpioNumber
        /// </summary>
        /// <value>
        /// The hpioNumber
        /// </value>
        [DataMember]
        public string HpioNumber
        {
            get { return hpioNumber; }
            set { hpioNumber = value; }
        }

        /// <summary>
        /// Gets or sets the OnlyNameIndicator
        /// </summary>
        /// <value>
        /// The onlyNameIndicator
        /// </value>
        [DataMember]
        public bool OnlyNameIndicator
        {
            get { return onlyNameIndicator; }
            set { onlyNameIndicator = value; }
        }

        /// <summary>
        /// Gets or sets the Sex (Gender)
        /// </summary>
        /// <value>
        /// The sex of the individual
        /// </value>
        [DataMember]
        public SexType? Sex
        {
            get { return sex; }
            set { sex = value; }
        }

        #endregion Properties
    }
}