﻿using System;
using System.Runtime.Serialization;
using nehta.mcaR50.ProviderSearchForProviderIndividual;

namespace HIPS.HpiiSchemas
{
    /// <summary>
    /// This class is used for the International Address Structure
    /// </summary>

    [KnownType(typeof(InternationalAddress))]
    [Serializable]
    [DataContract]
    public class InternationalAddress
    {
        #region Private Members

        private CountryType? country;
        private string internationalAddressLine;
        private string internationalPostcode;
        private string internationalStateProvince;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the Country
        /// </summary>
        /// <value>
        /// The country
        /// </value>
        [DataMember]
        public CountryType? Country
        {
            get { return country; }
            set { country = value; }
        }

        /// <summary>
        /// Gets or sets the InternationalAddressLine
        /// </summary>
        /// <value>
        /// The internationalAddressLine
        /// </value>
        [DataMember]
        public string InternationalAddressLine
        {
            get { return internationalAddressLine; }
            set { internationalAddressLine = value; }
        }

        /// <summary>
        /// Gets or sets the InternationalPostcode
        /// </summary>
        /// <value>
        /// The internationalPostcode
        /// </value>
        [DataMember]
        public string InternationalPostcode
        {
            get { return internationalPostcode; }
            set { internationalPostcode = value; }
        }

        /// <summary>
        /// Gets or sets the InternationalStateProvince
        /// </summary>
        /// <value>
        /// The internationalStateProvince
        /// </value>
        [DataMember]
        public string InternationalStateProvince
        {
            get { return internationalStateProvince; }
            set { internationalStateProvince = value; }
        }

        #endregion Properties
    }
}