﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the DocumentFormat table
    /// </summary>
    public class DocumentFormatDl : BaseDl
    {
        #region Methods

        /// <summary>
        /// Gets the document format with the specified document format id.
        /// </summary>
        /// <param name="documentFormatId">The document format id.</param>
        /// <returns>The document format object</returns>
        public DocumentFormat Get(int documentFormatId)
        {
            DocumentFormat result = new DocumentFormat();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.DocumentFormatGet"))
                {
                    command.Parameters.Add(new SqlParameter("@DocumentFormatId", documentFormatId));
                    PopulateBusinessObject<DocumentFormat>(command.ExecuteReader(), result);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageDocumentFormatGet, ex, User, LogMessage.HIPS_MESSAGE_019);
            }
            return result;
        }

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<DocumentFormat> GetAll()
        {
            return GetAll(null);
        }

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<DocumentFormat> GetAll(DateTime? lastUpdated)
        {
            List<DocumentFormat> results = new List<DocumentFormat>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.DocumentFormatGet"))
                {
                    if (lastUpdated.HasValue)
                    {
                        command.Parameters.Add(new SqlParameter("@DateModified", lastUpdated.Value));
                    }
                    results = GetPopulatedBusinessList<DocumentFormat>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageDocumentFormatGet, ex, User, LogMessage.HIPS_MESSAGE_018);
            }
            return results;
        }

        #endregion Methods
    }
}