﻿using System.Data.SqlClient;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the IhiLookupAudit table
    /// </summary>
    public class IhiLookupAuditDl : BaseDl
    {
        #region Constructors

        public IhiLookupAuditDl(UserDetails user)
            : base(user)
        {
        }

        #endregion Constructors

        #region Methods

        /// <summary>
        /// Inserts the specified ihi lookup audit.
        /// </summary>
        /// <param name="IhiLookupAudit">The ihi lookup audit.</param>
        /// <returns></returns>
        public bool Insert(IhiLookupAudit IhiLookupAudit)
        {
            using (SqlCommand command = GetSqlCommand("hips.IhiLookupAuditInsert"))
            {
                return base.Insert<IhiLookupAudit>(IhiLookupAudit, command);
            }
        }

        #endregion Methods
    }
}