﻿using System;

using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// CdaSetNumber schema.
    /// </summary>
    public class CdaSetNumber : BaseSchema
    {
        /// <summary>
        /// Gets or sets the admission date/time.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public DateTime AdmissionDateTime { get; set; }

        /// <summary>
        /// Gets or sets the CDA set number ID.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.AutoGeneratedKey)]
        public int? CdaSetNumberId
        {
            get
            {
                return base.Id;
            }

            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the discharge date/time.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public DateTime DischargeDateTime { get; set; }

        /// <summary>
        /// Gets or sets the count of documents already associated with this set.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int DocumentCount { get; set; }

        /// <summary>
        /// Gets or sets the document format ID.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public int DocumentFormatId { get; set; }

        /// <summary>
        /// Gets or sets the document type ID.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public int DocumentTypeId { get; set; }

        /// <summary>
        /// Gets or sets the episode ID.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public int EpisodeId { get; set; }

        /// <summary>
        /// Gets or sets the mode of separation.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public int ModeOfSeparationId { get; set; }
    }
}