﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a Clinical Document Type
    /// </summary>
    [KnownType(typeof(DocumentType))]
    [Serializable]
    [DataContract]
    public class DocumentType : BaseCodeListSchema
    {
        #region Properties

        /// <summary>
        /// Gets or sets the document type id.
        /// </summary>
        /// <value>
        /// The document type id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.AutoGeneratedKey)]
        public int? DocumentTypeId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        #endregion Properties

        /// <summary>
        /// Gets or sets the repository description.
        /// </summary>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string RepositoryDescription { get; set; }

        /// <summary>
        /// Gets or sets the foreign key to the Repository table.
        /// </summary>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public int RepositoryId { get; set; }

        /// <summary>
        /// Gets or sets the repository unique ID.
        /// </summary>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string RepositoryUniqueId { get; set; }
    }
}