﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a health provider individual working within one or more hospitals.
    /// </summary>
    [KnownType(typeof(HealthProviderIndividual))]
    [Serializable]
    [DataContract]
    public class HealthProviderIndividual : BaseSchema
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="HealthProviderIndividual" /> class.
        /// </summary>
        public HealthProviderIndividual()
        {
            HospitalHealthProviderIndividuals = new List<HospitalHealthProviderIndividual>();
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets or sets the name of the family.
        /// </summary>
        /// <value>
        /// The name of the family.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets the given names.
        /// </summary>
        /// <value>
        /// The given names.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string GivenNames { get; set; }

        /// <summary>
        /// Gets or sets the health provider individual id.
        /// </summary>
        /// <value>
        /// The health provider individual id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.AutoGeneratedKey)]
        public int? HealthProviderIndividualId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the list of hospital links for this provider.
        /// </summary>
        /// <value>
        /// The list of hospital links for this provider.
        /// </value>
        [DataMember]
        public List<HospitalHealthProviderIndividual> HospitalHealthProviderIndividuals { get; set; }

        /// <summary>
        /// Gets or sets the hpil.
        /// </summary>
        /// <value>
        /// The hpil.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string HpiI { get; set; }

        /// <summary>
        /// Gets or sets the hpii last validated date.
        /// </summary>
        /// <value>
        /// The hpii last validated date.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public DateTime? HpiILastValidatedDate { get; set; }

        /// <summary>
        /// Gets or sets the Identifier of this provider allocated by the jurisdiction's Identity and Access Management (IAM) system (e.g. Health Active Directory account)
        /// </summary>
        /// <value>
        /// The iam provider identifier.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string IamProviderIdentifier { get; set; }

        /// <summary>
        /// Gets or sets the suffix.
        /// </summary>
        /// <value>
        /// The suffix.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string Suffix { get; set; }

        /// <summary>
        /// Gets or sets the suffix id.
        /// </summary>
        /// <value>
        /// The suffix id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int SuffixId { get; set; }

        /// <summary>
        /// Gets or sets the title.
        /// </summary>
        /// <value>
        /// The title.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string Title { get; set; }

        /// <summary>
        /// Gets or sets the title id.
        /// </summary>
        /// <value>
        /// The title id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int TitleId { get; set; }

        #endregion Properties
    }
}