﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents the Medicare numbers that should be excluded.
    /// </summary>
    [KnownType(typeof(MedicareExclusion))]
    [Serializable]
    [DataContract]
    public class MedicareExclusion : BaseListSchema
    {
        #region Fields

        private string medicareNumber;

        #endregion Fields

        /// <summary>
        /// Gets or sets the Medicare exclusion id.
        /// </summary>
        /// <value>
        /// The Medicare exclusion id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ApplicationGeneratedKey)]
        public int? MedicareExclusionId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the Medicare card number (10 digits including check digit).
        /// </summary>
        /// <value>
        /// The Medicare card number.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string MedicareNumber
        {
            get
            {
                return this.medicareNumber;
            }
            set
            {
                Set(() => MedicareNumber, ref this.medicareNumber, value);
            }
        }
    }
}