﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a patient master to a contact
    /// </summary>
    [KnownType(typeof(PatientMasterContact))]
    [Serializable]
    [DataContract]
    public class PatientMasterContact : BaseSchema
    {
        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="PatientMasterContact"/> class.
        /// </summary>
        public PatientMasterContact()
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="PatientMasterContact"/> class.
        /// </summary>
        /// <param name="patientMasterId">The patient master id.</param>
        /// <param name="contectId">The contect id.</param>
        public PatientMasterContact(int patientMasterId, int contectId)
        {
            PatientMasterId = patientMasterId;
            ContactId = contectId;
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets or sets the contact id.
        /// </summary>
        /// <value>
        /// The contact id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ApplicationGeneratedKey)]
        public int ContactId { get; set; }

        /// <summary>
        /// Gets or sets the patient master id.
        /// </summary>
        /// <value>
        /// The patient master id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ApplicationGeneratedKey)]
        public int PatientMasterId { get; set; }

        #endregion Properties
    }
}