﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a name suffix (provider name or patient name)
    /// </summary>
    [KnownType(typeof(Suffix))]
    [Serializable]
    [DataContract]
    public class Suffix : BaseCodeListSchema
    {
        /// <summary>
        /// Gets or sets the suffix id.
        /// </summary>
        /// <value>
        /// The suffix id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.AutoGeneratedKey)]
        public int? SuffixId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }
    }
}