﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This object is used for the package response from the “DocumentList” methods.
    /// The PatientIdentifierBase class must be defined in the object before using
    /// </summary>
    [Serializable]
    [DataContract(Name = "DocumentListResponse")]
    public class DocumentListResponse<T> where T : PatientIdentifierBase
    {
        #region Private Members

        private IList<DocumentMetaDataItem> documentList = new List<DocumentMetaDataItem>();
        private HipsResponse hipsResponse = new HipsResponse(HipsResponseIndicator.SystemError, null);
        private String ihiNumber;
        private T patientIdentifier;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the DocumentList IList.
        /// List of the Document Meta Data Items.
        /// </summary>
        /// <value>
        /// The DocumentList
        /// </value>
        [DataMember]
        public IList<DocumentMetaDataItem> DocumentList
        {
            get { return documentList; }
            set { documentList = value; }
        }

        /// <summary>
        /// Gets or sets the HipsResponse.
        /// Common Response Object.
        /// </summary>
        /// <value>
        /// The hipsResponse
        /// </value>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get { return hipsResponse; }
            set { hipsResponse = value; }
        }

        /// <summary>
        /// Gets or sets the IhiNumber.
        /// IHI number (for those requests where the IHI was not used as a parameter the IHI that was returned from the PCEHR is also added).
        /// </summary>
        /// <value>
        /// The ihiNumber
        /// </value>
        [DataMember]
        public String IhiNumber
        {
            get { return ihiNumber; }
            set { ihiNumber = value; }
        }

        /// <summary>
        /// Gets or sets the PatientIdentifier.
        /// Patient Identifier Class that matches the same object that was used as the passed in PatientIdentifier Class.
        /// </summary>
        /// <value>
        /// The PatientIdentifier
        /// </value>
        [DataMember]
        public T PatientIdentifier
        {
            get { return patientIdentifier; }
            set { patientIdentifier = value; }
        }

        #endregion Properties
    }
}