﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using Nehta.VendorLibrary.PCEHR;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This object holds all query parameters that are to be sent to the document registry for retrieval.
    /// </summary>
    [KnownType(typeof(DocumentQuery))]
    [Serializable]
    [DataContract]
    public class DocumentQuery
    {
        #region Private Members

        private DateTime? creationTimeFrom = null;
        private DateTime? creationTimeTo = null;
        private IList<ClassCodes> documentClassCode = null;
        private IList<DocumentStatus> documentStatus = null;
        private String documentUniqueId = null;
        private IList<string> formatCodes = null;
        private IList<HealthcareFacilityTypeCodes> healthCareFacilityType = null;
        private IList<PracticeSettingTypes> practiceSettingTypes = null;
        private DateTime? serviceStartTimeFrom = null;
        private DateTime? serviceStartTimeTo = null;
        private DateTime? serviceStopTimeFrom = null;
        private DateTime? serviceStopTimeTo = null;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the start of the range for the Document Creation Time.
        /// This is the date and time when the document was completed, not when
        /// work on it started.
        /// </summary>
        [DataMember]
        public DateTime? CreationTimeFrom
        {
            get { return creationTimeFrom; }
            set { creationTimeFrom = value; }
        }

        /// <summary>
        /// Gets or sets the end of the range for the Document Creation Time.
        /// </summary>
        [DataMember]
        public DateTime? CreationTimeTo
        {
            get { return creationTimeTo; }
            set { creationTimeTo = value; }
        }

        /// <summary>
        /// Gets or sets a list of document class codes (also called document type codes) to filter the list of documents.
        /// </summary>
        [DataMember]
        public IList<ClassCodes> DocumentClassCode
        {
            get { return documentClassCode; }
            set { documentClassCode = value; }
        }

        /// <summary>
        /// <para>Gets or sets a list of Document Status codes to filter the list of documents.</para>
        /// <para>Status code "Approved" will list active documents. Status code
        /// "Deprecated" will list both removed documents and superseded
        /// documents (previous versions). Status code "Deleted" will list
        /// only removed documents.</para>
        /// <para>Superseded documents can be retrieved, but removed documents cannot.
        /// A provider organisation can reinstate a document that it removed with
        /// removal reason "withdrawn" by uploading a new version. A consumer can
        /// reinstate a document that was removed with the removal reason
        /// "elect to remove". Once reinstated, you will then be able to view it.
        /// Providers or consumers cannot reinstate documents removed with
        /// removal reason "incorrect identity".
        /// You can amend a document that a consumer has removed, however will not
        /// be able to view the removed document or any documents in its set unless
        /// the consumer reinstates it.</para>
        /// </summary>
        [DataMember]
        public IList<DocumentStatus> DocumentStatus
        {
            get { return documentStatus; }
            set { documentStatus = value; }
        }

        /// <summary>
        /// Gets or sets the Unique ID for retrieving the metadata for a single document.
        /// </summary>
        [DataMember]
        public string DocumentUniqueId
        {
            get { return documentUniqueId; }
            set { documentUniqueId = value; }
        }

        /// <summary>
        /// Gets or sets a list of document format codes (also known as template IDs).
        /// Refer to the Code column in the DocumentFormat table for examples.
        /// </summary>
        [DataMember]
        public IList<string> FormatCodes
        {
            get { return formatCodes; }
            set { formatCodes = value; }
        }

        /// <summary>
        /// Gets or sets a list of Health Care Facility Types to filter the list of documents.
        /// </summary>
        [DataMember]
        public IList<HealthcareFacilityTypeCodes> HealthCareFacilityType
        {
            get { return healthCareFacilityType; }
            set { healthCareFacilityType = value; }
        }

        /// <summary>
        /// Gets or sets a list of Practice Settings (also called Clinical Speciality Codes) to filter the list of documents.
        /// </summary>
        [DataMember]
        public IList<PracticeSettingTypes> PracticeSettingTypes
        {
            get { return practiceSettingTypes; }
            set { practiceSettingTypes = value; }
        }

        /// <summary>
        /// Gets or sets the start of the range for the service start time.
        /// The service start time is the date and time when the healthcare
        /// service that caused the document started, e.g. the admission of
        /// the patient.
        /// </summary>
        [DataMember]
        public DateTime? ServiceStartTimeFrom
        {
            get { return serviceStartTimeFrom; }
            set { serviceStartTimeFrom = value; }
        }

        /// <summary>
        /// Gets or sets the end of the range for the service start time.
        /// </summary>
        [DataMember]
        public DateTime? ServiceStartTimeTo
        {
            get { return serviceStartTimeTo; }
            set { serviceStartTimeTo = value; }
        }

        /// <summary>
        /// Gets or sets the start of the range for the service stop time.
        /// The service stop time is the date and time when the healthcare
        /// service that caused the document ended, e.g. the discharge of
        /// the patient. In many cases it's equal to the service start time.
        /// </summary>
        [DataMember]
        public DateTime? ServiceStopTimeFrom
        {
            get { return serviceStopTimeFrom; }
            set { serviceStopTimeFrom = value; }
        }

        /// <summary>
        /// Gets or sets the end of the range for the service stop time.
        /// </summary>
        [DataMember]
        public DateTime? ServiceStopTimeTo
        {
            get { return serviceStopTimeTo; }
            set { serviceStopTimeTo = value; }
        }

        #endregion Properties
    }
}