﻿namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// Mapping to the public fields exposed from the CodedValueAttribute Attribute extension (Nehta.VendorLibrary.PCEHR.CodedValueAttribute) used for all codes enums
    /// </summary>
    public enum CodedValueAttributeField
    {
        /// <summary>
        /// Coding system name.
        /// </summary>
        CodingSystem,

        /// <summary>
        /// Coding system OID.
        /// </summary>
        CodingSystemOID,

        /// <summary>
        /// Concept code.
        /// </summary>
        ConceptCode,

        /// <summary>
        /// Concept name.
        /// </summary>
        ConceptName,

        /// <summary>
        /// Alternate name.
        /// </summary>
        AlternateName
    }

    /// <summary>
    /// Classification of the action required in response to a PCEHR system message.
    /// </summary>
    public enum FaultAction
    {
        /// <summary>
        /// The action was completed normally. No further action is required.
        /// </summary>
        Completed,

        /// <summary>
        /// The action was completed but there was an issue that should be
        /// investigated and corrected when sufficient resources are available.
        /// </summary>
        CompletedWithWarnings,

        /// <summary>
        /// The remote system encountered an unexpected situation and was unable
        /// to process the message. It is likely that trying the same message
        /// again will result in successful processing. For operations in which
        /// a queue is involved, the message may be pushed back onto the queue.
        /// </summary>
        TransientFailure,

        /// <summary>
        /// The message was badly formed and could not be processed. Trying the
        /// same message again is unlikely to result in successful processing.
        /// The error must be investigated and the contents or configuration
        /// corrected before trying again.
        /// </summary>
        PermanentFailure,

        /// <summary>
        /// An unexpected service message was returned. This should be investigated
        /// similarly to when a permanent failure occurs.
        /// </summary>
        Unknown
    }

    /// <summary>
    /// This enumeration is used for returning the status of the request to gain acccess.
    /// </summary>
    public enum GainPcehrAccessStatus
    {
        /// <summary>
        /// Access to the PCEHR was permitted.
        /// </summary>
        Permit,

        /// <summary>
        /// Access to the PCEHR was denied.
        /// </summary>
        Deny
    }

    /// <summary>
    /// Status of the document process for upload and remove.
    /// </summary>
    public enum LocalDocumentStatus
    {
        /// <summary>
        /// The document status is unknown.
        /// </summary>
        Unknown = 0,

        /// <summary>
        /// The document is queued for upload.
        /// </summary>
        PendingUpload = 1,

        /// <summary>
        /// The document has been uploaded.
        /// </summary>
        Uploaded = 2,

        /// <summary>
        /// The document failed to upload.
        /// </summary>
        FailedUpload = 3,

        /// <summary>
        /// The document is queued for removal.
        /// </summary>
        PendingRemove = 4,

        /// <summary>
        /// The document has been removed.
        /// </summary>
        Removed = 5,

        /// <summary>
        /// The document failed to remove.
        /// </summary>
        FailedRemove = 6
    }
}