﻿using System.ServiceModel;

using HIPS.ServiceContracts.Cda.Message;
using HIPS.ServiceContracts.Common.Fault;

namespace HIPS.ServiceContracts.Cda
{
    /// <summary>
    /// Web service interface for the CDA service.
    /// </summary>
    [WCFExtras.Wsdl.Documentation.XmlComments]
    [ServiceContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.CDA_V1)]
    public interface ICdaService
    {
        /// <summary>
        /// Creates a CDA discharge summary document that wraps a PDF document body.
        /// This may be for the purpose of uploading the discharge summary to the
        /// PCEHR or for provider-to-provider (P2P) secure message delivery (SMD).
        /// This takes in the PDF document, required metadata, and any attachments
        /// and creates a CDA document.
        /// </summary>
        /// <param name="request">Request containing a PDF and required metadata for creating the CDA package.</param>
        /// <returns>Response containing details of the created document.</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        [FaultContract(typeof(InvalidUserFault))]
        [FaultContract(typeof(HiServiceFault))]
        [FaultContract(typeof(PcehrServiceFault))]
        [FaultContract(typeof(ItemNotFoundFault))]
        CreateDischargeSummaryLevel1AResponse CreateDischargeSummaryLevel1A(CreateDischargeSummaryLevel1ARequest request);
    }
}