﻿using System.Collections.Generic;
using System.Runtime.Serialization;

namespace HIPS.ServiceContracts.Common.DTO
{
    /// <summary>
    /// Represents a generic message, generally to provide additional contextual
    /// information, such as assisting with how a response message is interpreted.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class Message
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="Message" /> class.
        /// </summary>
        public Message()
        {
            this.Messages = new List<Message>();
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets or sets the code associated with the message.
        /// </summary>
        [DataMember(IsRequired = false)]
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets any additional data associated with the message.
        /// </summary>
        [DataMember(IsRequired = false)]
        public object Data { get; set; }

        /// <summary>
        /// Gets or sets a detailed description of the message content.
        /// </summary>
        [DataMember(IsRequired = true)]
        public string Description { get; set; }

        /// <summary>
        /// Gets or sets the level associated with the message.
        /// </summary>
        [DataMember(IsRequired = true)]
        public MessageLevel Level { get; set; }

        /// <summary>
        /// Gets or sets the set of messages associated with the message.
        /// </summary>
        [DataMember(IsRequired = true)]
        public List<Message> Messages { get; set; }

        /// <summary>
        /// Gets or sets a string identifying the origin of the message, such as "HIPS" or "PCEHR".
        /// </summary>
        [DataMember(IsRequired = true)]
        public string Origin { get; set; }

        #endregion Properties
    }
}