﻿using System.Runtime.Serialization;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Common.DTO
{
    /// <summary>
    /// Structured Australian Address DTO. This object represents a physical address,
    /// which may be a street address or a postal address.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class StructuredAustralianAddress
    {
        #region Properties

        /// <summary>
        /// Gets or sets the Australian state. The valid codes are defined in AS 5017-2006
        /// in the table "Australian State/Territory Identifier - Postal".
        /// This is mandatory for an Australian address, and must not be provided for an
        /// international address.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.DomainValidator(domain: AustralianState.None, Negated = true)]
        public AustralianState State { get; set; }

        /// <summary>
        /// Gets or sets the suburb, town or locality.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 50)]
        public string PlaceName { get; set; }

        /// <summary>
        /// Gets or sets the Australian postcode.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 4)]
        public string Postcode { get; set; }

        /// <summary>
        /// Gets or sets the level number.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(1, 4)]
        [EntLibVal.Validators.IgnoreNulls]
        public string LevelNumber { get; set; }

        /// <summary>
        /// Gets or sets the level type code.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(1, 2)]
        [EntLibVal.Validators.IgnoreNulls]
        public string LevelType { get; set; }

        /// <summary>
        /// Gets or sets the Lot Number.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(1, 15)]
        [EntLibVal.Validators.IgnoreNulls]
        public string LotNumber { get; set; }

        /// <summary>
        /// Gets or sets the Postal Delivery Number.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(1, 11)]
        [EntLibVal.Validators.IgnoreNulls]
        public string PostalDeliveryNumber { get; set; }

        /// <summary>
        /// Gets or sets the Postal Delivery Type code.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(1, 11)]
        [EntLibVal.Validators.IgnoreNulls]
        public string PostalDeliveryType { get; set; }

        /// <summary>
        /// Gets or sets the address site name.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(1, 30)]
        [EntLibVal.Validators.IgnoreNulls]
        public string SiteName { get; set; }

        /// <summary>
        /// Gets or sets the Street Name.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(1, 30)]
        [EntLibVal.Validators.IgnoreNulls]
        public string StreetName { get; set; }

        /// <summary>
        /// Gets or sets the Street Number.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(1, 12)]
        [EntLibVal.Validators.IgnoreNulls]
        public string StreetNumber { get; set; }

        /// <summary>
        /// Gets or sets the Street Suffix Type code.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(1, 2)]
        [EntLibVal.Validators.IgnoreNulls]
        public string StreetSuffixType { get; set; }

        /// <summary>
        /// Gets or sets the Street Type code.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(1, 9)]
        [EntLibVal.Validators.IgnoreNulls]
        public string StreetType { get; set; }

        /// <summary>
        /// Gets or sets the Unit Number.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(1, 6)]
        [EntLibVal.Validators.IgnoreNulls]
        public string UnitNumber { get; set; }

        /// <summary>
        /// Gets or sets the Unit Type code.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(1, 8)]
        [EntLibVal.Validators.IgnoreNulls]
        public string UnitType { get; set; }

        #endregion Properties


    }
}