﻿using System.Runtime.Serialization;

namespace HIPS.ServiceContracts.Common.Fault
{
    /// <summary>
    /// Represents a general failure within the service operation.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class ServiceOperationFault : FaultBase
    {
        /// <summary>
        /// Gets or sets the fault code. This corresponds to the HipsResponse.ResponseCode property on V1 services.
        /// </summary>
        [DataMember]
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets the fault description. This corresponds to the HipsResponse.ResponseCodeDescription property on V1 services.
        /// </summary>
        [DataMember]
        public string Description { get; set; }

        /// <summary>
        /// Gets or sets the fault details. This corresponds to the HipsResponse.ResponseCodeDetails property on V1 services.
        /// </summary>
        [DataMember]
        public string Details { get; set; }

        /// <summary>
        /// Gets or sets the fault type. This corresponds to the HipsResponse.Status property on V1 services.
        /// </summary>
        [DataMember]
        public string Type { get; set; }
    }
}