﻿using System.ServiceModel;

namespace HIPS.ServiceContracts.Common.Message
{
    /// <summary>
    /// Abstract generic base class for all response messages associated with service operations that return operation-specific result data.
    /// </summary>
    /// <typeparam name="T">Type of the the operation specific result data.</typeparam>
    [MessageContract(WrapperNamespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public abstract class DataResponseBase<T> : ResponseBase
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="DataResponseBase{T}" /> class.
        /// </summary>
        public DataResponseBase()
            : base()
        {
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets or sets a value representing operation-specific result data.
        /// </summary>
        [MessageBodyMember(Order = 3)]
        public virtual T Data { get; set; }

        #endregion Properties
    }
}